/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class ComputedAttribute
extends SimpleNodeConstructor {
    private Expression attributeName;
    private Expression namespace = null;
    private NamespaceResolver nsContext;
    private SimpleType schemaType;
    private int annotation;
    private int validationAction;
    private boolean allowNameAsQName;
    private int options;

    public ComputedAttribute(Expression expression, Expression expression2, NamespaceResolver namespaceResolver, int n, SimpleType simpleType, int n2, boolean bl) {
        this.attributeName = expression;
        this.namespace = expression2;
        this.nsContext = namespaceResolver;
        this.schemaType = simpleType;
        this.annotation = n2 == -1 ? 631 : n2;
        this.validationAction = n;
        this.options = 0;
        this.allowNameAsQName = bl;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public int getInstructionNameCode() {
        return 131;
    }

    public Expression getNameExpression() {
        return this.attributeName;
    }

    public Expression getNamespaceExpression() {
        return this.namespace;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsContext;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.ATTRIBUTE;
    }

    public int getCardinality() {
        return 16384;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.attributeName = this.attributeName.simplify(staticContext);
        if (this.namespace != null) {
            this.namespace = this.namespace.simplify(staticContext);
        }
        return super.simplify(staticContext);
    }

    public void localTypeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        String[] stringArray;
        Serializable serializable;
        this.attributeName = this.attributeName.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.attributeName);
        RoleLocator roleLocator = new RoleLocator(4, "attribute/name", 0, null);
        roleLocator.setSourceLocator(this);
        if (this.allowNameAsQName) {
            boolean bl;
            this.attributeName = TypeChecker.staticTypeCheck(this.attributeName, SequenceType.SINGLE_ATOMIC, false, roleLocator, staticContext);
            serializable = staticContext.getConfiguration().getTypeHierarchy();
            boolean bl2 = ((TypeHierarchy)serializable).relationship((ItemType)(stringArray = this.attributeName.getItemType((TypeHierarchy)serializable)), BuiltInAtomicType.STRING) != 4 || ((TypeHierarchy)serializable).relationship((ItemType)stringArray, BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
            boolean bl3 = bl = ((TypeHierarchy)serializable).relationship((ItemType)stringArray, BuiltInAtomicType.QNAME) != 4;
            if (!bl2 && !bl) {
                StaticError staticError = new StaticError("The attribute name must be either an xs:string, an xs:QName, or untyped atomic");
                staticError.setErrorCode("XPTY0004");
                staticError.setIsTypeError(true);
                staticError.setLocator(this);
                throw staticError;
            }
        } else {
            this.attributeName = TypeChecker.staticTypeCheck(this.attributeName, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        }
        if (this.namespace != null) {
            this.namespace.typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.namespace);
            roleLocator = new RoleLocator(4, "attribute/namespace", 0, null);
            roleLocator.setSourceLocator(this);
            this.namespace = TypeChecker.staticTypeCheck(this.namespace, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        }
        if (Literal.isAtomic(this.attributeName)) {
            try {
                serializable = (AtomicValue)((Literal)this.attributeName).getValue();
                if (serializable instanceof StringValue) {
                    stringArray = staticContext.getConfiguration().getNameChecker().checkQNameParts(((AtomicValue)serializable).getStringValueCS());
                    if (this.namespace == null) {
                        String string = this.getNamespaceResolver().getURIForPrefix(stringArray[0], true);
                        if (string == null) {
                            StaticError staticError = new StaticError("Prefix " + stringArray[0] + " has not been declared");
                            staticError.setErrorCode("XPST0081");
                            throw staticError;
                        }
                        this.namespace = new StringLiteral(string);
                    }
                }
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(3);
        if (this.select != null) {
            arrayList.add(this.select);
        }
        arrayList.add(this.attributeName);
        if (this.namespace != null) {
            arrayList.add(this.namespace);
        }
        return arrayList.iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        if (this.attributeName == expression) {
            this.attributeName = expression2;
            bl = true;
        }
        if (this.namespace == expression) {
            this.namespace = expression2;
            bl = true;
        }
        return bl;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.attributeName = this.doPromotion(this.attributeName, promotionOffer);
        if (this.namespace != null) {
            this.namespace = this.doPromotion(this.namespace, promotionOffer);
        }
        super.promoteInst(promotionOffer);
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        if (schemaType instanceof SimpleType) {
            StaticError staticError = new StaticError("Attributes are not permitted here: the containing element is of simple type " + schemaType.getDescription());
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        CharSequence charSequence;
        int n;
        int n2;
        SequenceReceiver sequenceReceiver;
        int n3;
        block12: {
            n3 = this.evaluateNameCode(xPathContext);
            if (n3 == -1) {
                return null;
            }
            sequenceReceiver = xPathContext.getReceiver();
            n2 = this.options;
            n = this.annotation;
            charSequence = ((Object)this.expandChildren(xPathContext)).toString();
            if (this.schemaType != null) {
                try {
                    ValidationException validationException = this.schemaType.validateContent(charSequence, DummyNamespaceResolver.getInstance(), xPathContext.getConfiguration().getNameChecker());
                    if (validationException != null) {
                        ValidationException validationException2 = new ValidationException("Attribute value " + Err.wrap(charSequence, 4) + " does not match the required type " + this.schemaType.getDescription() + ". " + validationException.getMessage());
                        validationException2.setErrorCode("XTTE1540");
                        throw validationException2;
                    }
                    break block12;
                }
                catch (UnresolvedReferenceException unresolvedReferenceException) {
                    throw new ValidationException(unresolvedReferenceException);
                }
            }
            if (this.validationAction == 1 || this.validationAction == 2) {
                try {
                    n = xPathContext.getConfiguration().validateAttribute(n3, charSequence, this.validationAction);
                }
                catch (ValidationException validationException) {
                    DynamicError dynamicError = DynamicError.makeDynamicError(validationException);
                    String string = validationException.getErrorCodeLocalPart();
                    if (string == null) {
                        string = this.validationAction == 1 ? "XTTE1510" : "XTTE1515";
                    }
                    dynamicError.setErrorCode(string);
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setLocator(this);
                    dynamicError.setIsTypeError(true);
                    throw dynamicError;
                }
            }
        }
        if ((n3 & 0xFFFFF) == 388) {
            charSequence = Whitespace.collapseWhitespace(charSequence);
        }
        try {
            sequenceReceiver.attribute(n3, n, charSequence, this.locationId, n2);
        }
        catch (XPathException xPathException) {
            throw ComputedAttribute.dynamicError(this, xPathException, xPathContext);
        }
        return null;
    }

    public int evaluateNameCode(XPathContext xPathContext) throws XPathException {
        Object object;
        NamePool namePool = xPathContext.getNamePool();
        Item item = this.attributeName.evaluateItem(xPathContext);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (item instanceof StringValue) {
            Object object2;
            object = item.getStringValueCS();
            if (Whitespace.containsWhitespace((CharSequence)object)) {
                object = object.toString().trim();
            }
            try {
                object2 = xPathContext.getConfiguration().getNameChecker().getQNameParts((CharSequence)object);
                string = object2[0];
                string2 = object2[1];
            }
            catch (QNameException qNameException) {
                DynamicError dynamicError = new DynamicError("Invalid attribute name: " + object, this);
                dynamicError.setErrorCode(this.isXSLT() ? "XTDE0850" : "XQDY0074");
                dynamicError.setXPathContext(xPathContext);
                throw ComputedAttribute.dynamicError(this, dynamicError, xPathContext);
            }
            if (object.toString().equals("xmlns") && this.namespace == null) {
                object2 = new DynamicError("Invalid attribute name: " + object, this);
                ((XPathException)object2).setErrorCode(this.isXSLT() ? "XTDE0855" : "XQDY0044");
                ((DynamicError)object2).setXPathContext(xPathContext);
                throw ComputedAttribute.dynamicError(this, (XPathException)object2, xPathContext);
            }
            if (string.equals("xmlns")) {
                if (this.namespace == null) {
                    object2 = new DynamicError("Invalid attribute name: " + object, this);
                    ((XPathException)object2).setErrorCode(this.isXSLT() ? "XTDE0860" : "XQDY0044");
                    ((DynamicError)object2).setXPathContext(xPathContext);
                    throw ComputedAttribute.dynamicError(this, (XPathException)object2, xPathContext);
                }
                string = "";
            }
        } else if (item instanceof QNameValue && this.allowNameAsQName) {
            string2 = ((QNameValue)item).getLocalName();
            string3 = ((QNameValue)item).getNamespaceURI();
            if (string3 == null) {
                string3 = "";
            }
            string = string3.equals("") ? "" : ((QNameValue)item).getPrefix();
        } else {
            DynamicError dynamicError = new DynamicError("Attribute name must be either a string or a QName", this);
            dynamicError.setErrorCode("XPTY0004");
            dynamicError.setIsTypeError(true);
            dynamicError.setXPathContext(xPathContext);
            throw ComputedAttribute.dynamicError(this, dynamicError, xPathContext);
        }
        if (this.namespace == null && string3 == null) {
            if (string.length() == 0) {
                string3 = "";
            } else {
                string3 = this.nsContext.getURIForPrefix(string, false);
                if (string3 == null) {
                    object = new DynamicError("Undeclared prefix in attribute name: " + string, this);
                    ((XPathException)object).setErrorCode(this.isXSLT() ? "XTDE0860" : "XQDY0074");
                    ((DynamicError)object).setXPathContext(xPathContext);
                    throw ComputedAttribute.dynamicError(this, (XPathException)object, xPathContext);
                }
            }
        } else {
            if (string3 == null) {
                if (this.namespace instanceof StringLiteral) {
                    string3 = ((StringLiteral)this.namespace).getStringValue();
                } else {
                    string3 = this.namespace.evaluateAsString(xPathContext);
                    if (!AnyURIValue.isValidURI(string3)) {
                        object = new DynamicError("The value of the namespace attribute must be a valid URI");
                        ((XPathException)object).setErrorCode("XTDE0865");
                        ((DynamicError)object).setXPathContext(xPathContext);
                        ((TransformerException)object).setLocator(this);
                        throw object;
                    }
                }
            }
            if (string3.length() == 0) {
                string = "";
            } else if (string.length() == 0 && (string = namePool.suggestPrefixForURI(string3)) == null) {
                string = "ns0";
            }
        }
        return namePool.allocate(string, string3, string2);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "attribute ");
        printStream.println(ExpressionTool.indent(n + 1) + "name");
        this.attributeName.display(n + 2, printStream, configuration);
        super.display(n + 1, printStream, configuration);
    }
}

