/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.servlet.session;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.servlet.session.DistSession;

public class DistSessionPoolManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$utils$servlet$session$DistSessionPoolManager == null ? (class$org$apache$jcs$utils$servlet$session$DistSessionPoolManager = DistSessionPoolManager.class$("org.apache.jcs.utils.servlet.session.DistSessionPoolManager")) : class$org$apache$jcs$utils$servlet$session$DistSessionPoolManager));
    DistSession[] pool;
    boolean[] inUse;
    static /* synthetic */ Class class$org$apache$jcs$utils$servlet$session$DistSessionPoolManager;

    public static void main(String[] args) {
        DistSessionPoolManager hpm = new DistSessionPoolManager(200);
        int num = 1000000;
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < num) {
            new DistSession();
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("New DistSession creation took " + String.valueOf(end - start) + " millis.");
        start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < num) {
            DistSession ht = hpm.getDistSession();
            hpm.returnDistSession(ht);
            ++i2;
        }
        end = System.currentTimeMillis();
        System.out.println("Pooled get and return of Hashtable took " + String.valueOf(end - start) + " millis.");
    }

    public DistSessionPoolManager(int initialPoolSize) {
        log.info((Object)("initialPoolSize = " + initialPoolSize));
        this.pool = new DistSession[initialPoolSize];
        this.inUse = new boolean[initialPoolSize];
        int i = this.pool.length - 1;
        while (i >= 0) {
            this.pool[i] = new DistSession();
            this.inUse[i] = false;
            --i;
        }
    }

    public synchronized DistSession getDistSession() {
        int i = this.inUse.length - 1;
        while (i >= 0) {
            if (!this.inUse[i]) {
                this.inUse[i] = true;
                return this.pool[i];
            }
            --i;
        }
        boolean[] old_inUse = this.inUse;
        this.inUse = new boolean[old_inUse.length + 10];
        System.arraycopy(old_inUse, 0, this.inUse, 0, old_inUse.length);
        DistSession[] old_pool = this.pool;
        this.pool = new DistSession[old_pool.length + 10];
        System.arraycopy(old_pool, 0, this.pool, 0, old_pool.length);
        int i2 = old_pool.length;
        while (i2 < this.pool.length) {
            this.pool[i2] = new DistSession();
            this.inUse[i2] = false;
            ++i2;
        }
        this.inUse[this.pool.length - 1] = true;
        return this.pool[this.pool.length - 1];
    }

    public synchronized void returnDistSession(DistSession v) {
        int i = this.inUse.length - 1;
        while (i >= 0) {
            if (this.pool[i] == v) {
                this.inUse[i] = false;
                v.clean();
                return;
            }
            --i;
        }
        log.warn((Object)("DistSession was not obtained from the pool: " + v));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

