/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean;

import java.io.File;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.Processor;
import org.apache.cocoon.bean.CocoonWrapper;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.language.generator.CompiledComponent;
import org.apache.cocoon.components.language.generator.ProgramGenerator;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.commandline.LinkSamplingEnvironment;
import org.apache.cocoon.util.IOUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class XSPPrecompileWrapper
extends CocoonWrapper {
    private SourceResolver sourceResolver;
    private static Options options;
    protected static final String HELP_OPT = "h";
    protected static final String LOG_KIT_OPT = "k";
    protected static final String CONTEXT_DIR_OPT = "c";
    protected static final String WORK_DIR_OPT = "w";
    protected static final String CONFIG_FILE_OPT = "C";
    protected static final String LOG_KIT_LONG = "logKitconfig";
    protected static final String CONTEXT_DIR_LONG = "contextDir";
    protected static final String WORK_DIR_LONG = "workDir";
    protected static final String HELP_LONG = "help";
    protected static final String CONFIG_FILE_LONG = "configFile";

    public void precompile() throws Exception {
        this.recursivelyPrecompile(this.context, this.context);
    }

    private void recursivelyPrecompile(File contextDir, File file) throws Exception {
        if (file.isDirectory()) {
            String[] entries = file.list();
            for (int i = 0; i < entries.length; ++i) {
                this.recursivelyPrecompile(contextDir, new File(file, entries[i]));
            }
        } else if (file.getName().toLowerCase().endsWith(".xsp")) {
            String contextFilePath = IOUtils.getContextFilePath((String)contextDir.getCanonicalPath(), (String)file.getCanonicalPath());
            this.processXSP(contextFilePath);
        }
    }

    protected void processXSP(String uri) throws Exception {
        String markupLanguage = "xsp";
        String programmingLanguage = "java";
        LinkSamplingEnvironment env = new LinkSamplingEnvironment("/", this.context, null, null, null, this.cliContext, this.log);
        this.precompile(uri, (Environment)env, markupLanguage, programmingLanguage);
    }

    protected void processXMAP(String uri) throws Exception {
        String markupLanguage = "sitemap";
        String programmingLanguage = "java";
        LinkSamplingEnvironment env = new LinkSamplingEnvironment("/", this.context, null, null, null, this.cliContext, this.log);
        this.precompile(uri, (Environment)env, markupLanguage, programmingLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void precompile(String fileName, Environment environment, String markupLanguage, String programmingLanguage) throws Exception {
        ProgramGenerator programGenerator = null;
        Source source = null;
        Object key = CocoonComponentManager.startProcessing((Environment)environment);
        CocoonComponentManager.enterEnvironment((Environment)environment, (ComponentManager)this.getComponentManager(), (Processor)this.cocoon);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("XSP generation begin:" + fileName);
            }
            System.out.println("Compiling " + fileName);
            programGenerator = (ProgramGenerator)this.getComponentManager().lookup(ProgramGenerator.ROLE);
            source = this.sourceResolver.resolveURI(fileName);
            CompiledComponent xsp = programGenerator.load((ComponentManager)this.getComponentManager(), source, markupLanguage, programmingLanguage, (org.apache.cocoon.environment.SourceResolver)environment);
            System.out.println("[XSP generated] " + xsp);
            if (this.log.isDebugEnabled()) {
                this.log.debug("XSP generation complete:" + xsp);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.sourceResolver.release(source);
            this.getComponentManager().release(programGenerator);
            CocoonComponentManager.leaveEnvironment();
            CocoonComponentManager.endProcessing((Environment)environment, (Object)key);
            throw throwable;
        }
        this.sourceResolver.release(source);
        this.getComponentManager().release((Component)programGenerator);
        CocoonComponentManager.leaveEnvironment();
        CocoonComponentManager.endProcessing((Environment)environment, (Object)key);
    }

    public static void main(String[] args) throws Exception {
        XSPPrecompileWrapper.setOptions();
        CommandLine line = new PosixParser().parse(options, args);
        XSPPrecompileWrapper wrapper = new XSPPrecompileWrapper();
        if (line.hasOption(HELP_OPT)) {
            XSPPrecompileWrapper.printUsage();
        }
        if (line.hasOption(WORK_DIR_OPT)) {
            String workDir = line.getOptionValue(WORK_DIR_OPT);
            if (workDir.equals("")) {
                System.exit(1);
            } else {
                wrapper.setWorkDir(line.getOptionValue(WORK_DIR_OPT));
            }
        }
        if (line.hasOption(CONTEXT_DIR_OPT)) {
            String contextDir = line.getOptionValue(CONTEXT_DIR_OPT);
            if (contextDir.equals("")) {
                System.exit(1);
            } else {
                wrapper.setContextDir(contextDir);
            }
        }
        if (line.hasOption(LOG_KIT_OPT)) {
            wrapper.setLogKit(line.getOptionValue(LOG_KIT_OPT));
        }
        if (line.hasOption(CONFIG_FILE_OPT)) {
            wrapper.setConfigFile(line.getOptionValue(CONFIG_FILE_OPT));
        }
        wrapper.initialize();
        wrapper.precompile();
        wrapper.dispose();
        System.exit(0);
    }

    private static void setOptions() {
        options = new Options();
        options.addOption(new Option(LOG_KIT_OPT, LOG_KIT_LONG, true, "use given file for LogKit Management configuration"));
        options.addOption(new Option(CONTEXT_DIR_OPT, CONTEXT_DIR_LONG, true, "use given dir as context"));
        options.addOption(new Option(WORK_DIR_OPT, WORK_DIR_LONG, true, "use given dir as working directory"));
        options.addOption(new Option(HELP_OPT, HELP_LONG, false, "print this message and exit"));
        options.addOption(new Option(CONFIG_FILE_OPT, CONFIG_FILE_LONG, true, "specify alternate location of the configuration file (default is ${contextDir}/cocoon.xconf)"));
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java org.apache.cocoon.bean.XSPPrecompileWrapper [options] ", options);
        System.exit(0);
    }

    public void initialize() throws Exception {
        super.initialize();
        this.sourceResolver = (SourceResolver)this.getComponentManager().lookup(SourceResolver.ROLE);
    }
}

