/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathIntrospector;

public class TemplateObjectModelHelper {
    private TemplateObjectModelHelper() {
    }

    private static void fillContext(Object contextObject, Map map) {
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(contextObject.getClass());
        if (bi.isDynamic()) {
            Class cl = bi.getDynamicPropertyHandlerClass();
            try {
                DynamicPropertyHandler h = (DynamicPropertyHandler)cl.newInstance();
                String[] result = h.getPropertyNames(contextObject);
                int len = result.length;
                int i = 0;
                while (i < len) {
                    try {
                        map.put(result[i], h.getProperty(contextObject, result[i]));
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        } else {
            PropertyDescriptor[] props = bi.getPropertyDescriptors();
            int len = props.length;
            int i = 0;
            while (i < len) {
                try {
                    Method read = props[i].getReadMethod();
                    if (read != null) {
                        map.put(props[i].getName(), read.invoke(contextObject, null));
                    }
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
                ++i;
            }
        }
    }

    public static Object getTemplateObjectModel(Map objectModel, Parameters parameters) {
        HashMap cocoon = new HashMap();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        cocoon.put("request", new DynamicMap(request));
        Session session = request.getSession(false);
        if (session != null) {
            cocoon.put("session", new DynamicMap(session));
        }
        cocoon.put("context", ObjectModelHelper.getContext((Map)objectModel));
        WebContinuation cont = FlowHelper.getWebContinuation((Map)objectModel);
        if (cont != null) {
            cocoon.put("continuation", cont);
        }
        if (parameters != null) {
            cocoon.put("parameters", Parameters.toProperties((Parameters)parameters));
        }
        HashMap map = new HashMap();
        map.put("cocoon", cocoon);
        Object contextObject = FlowHelper.getContextObject((Map)objectModel);
        if (contextObject instanceof Map) {
            map.putAll((Map)contextObject);
        } else if (contextObject != null) {
            TemplateObjectModelHelper.fillContext(contextObject, map);
        }
        return map;
    }

    public static class DynamicMap
    extends HashMap {
        protected final Object information;

        public DynamicMap(Object info) {
            this.information = info;
        }

        public Object get(Object key) {
            Object result = super.get(key);
            if (result == null) {
                result = this.getDynamicInfo(key);
            }
            return result;
        }

        public boolean containsKey(Object key) {
            boolean result = super.containsKey(key);
            if (!result) {
                result = this.getDynamicInfo(key) != null;
            }
            return result;
        }

        protected Object getDynamicInfo(Object key) {
            Object result = null;
            try {
                result = PropertyUtils.getProperty((Object)this.information, (String)key.toString());
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (result == null) {
                try {
                    result = MethodUtils.invokeMethod((Object)this.information, (String)"getAttribute", (Object)key.toString());
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (result != null) {
                this.put(key, result);
            }
            return result;
        }
    }
}

