/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ConfigurableServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class SectionCutterAction
extends ConfigurableServiceableAction
implements ThreadSafe {
    Vector sections = new Vector();

    public void configure(Configuration conf) throws ConfigurationException {
        try {
            Configuration[] sectionConfigurations = conf.getChildren("section");
            int i = 0;
            while (i < sectionConfigurations.length) {
                block6: {
                    try {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Creating one section");
                        }
                        this.sections.add(new Section(sectionConfigurations[i]));
                    }
                    catch (Exception e) {
                        this.getLogger().error("Failed configuring section", (Throwable)e);
                        if (!this.getLogger().isDebugEnabled()) break block6;
                        throw e;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot configure action", (Throwable)e);
        }
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters par) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap results = new HashMap();
        if (request != null) {
            boolean hasMatched = false;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Matching against '" + request.getSitemapURI() + "'");
            }
            Enumeration sectionsEnum = this.sections.elements();
            while (sectionsEnum.hasMoreElements() && !hasMatched) {
                Section section = (Section)sectionsEnum.nextElement();
                if (!section.matches(request.getSitemapURI())) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Matched '" + section.matchExpression + "'");
                }
                section.fillMap(results);
                hasMatched = true;
            }
        } else {
            this.getLogger().warn("Request was null");
        }
        return Collections.unmodifiableMap(results);
    }

    class Section {
        String matchExpression;
        Dictionary mapVars = new Hashtable();

        public Section(Configuration conf) throws Exception {
            this.matchExpression = conf.getAttribute("pattern");
            Configuration[] variables = conf.getChildren("set-var");
            int i = 0;
            while (i < variables.length) {
                this.mapVars.put(variables[i].getAttribute("name"), variables[i].getAttribute("value"));
                ++i;
            }
        }

        public boolean matches(String expression) {
            return expression.startsWith(this.matchExpression);
        }

        public void fillMap(Map map) {
            Enumeration keys = this.mapVars.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = this.mapVars.get(key);
                map.put(key, value);
            }
        }
    }
}

