/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.convertor;

import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;

public class ConversionResult {
    private ValidationError validationError;
    private boolean successful;
    private Object result;

    public ConversionResult(Object result) {
        this.successful = true;
        this.result = result;
    }

    public ConversionResult(ValidationError validationError) {
        this.successful = false;
        this.validationError = validationError;
    }

    public static ConversionResult create(String datatypeName) {
        ValidationError validationError = new ValidationError(new I18nMessage("datatype.conversion-failed", new String[]{"datatype." + datatypeName}, new boolean[]{true}, "forms"));
        return new ConversionResult(validationError);
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public ValidationError getValidationError() {
        if (this.successful) {
            throw new IllegalStateException("Cannot call getValidationError() if conversion is successful.");
        }
        return this.validationError;
    }

    public Object getResult() {
        if (!this.successful) {
            throw new IllegalStateException("Cannot call getResult() if conversion is not successful.");
        }
        return this.result;
    }
}

