/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.context.Context;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FlowJXPathSelectionList
implements SelectionList {
    private Context context;
    private String listPath;
    private String valuePath;
    private String labelPath;
    private Datatype datatype;
    private Object model;

    public FlowJXPathSelectionList(Context context, String listPath, String valuePath, String labelPath, Datatype datatype) {
        this.context = context;
        this.listPath = listPath;
        this.valuePath = valuePath;
        this.labelPath = labelPath;
        this.datatype = datatype;
    }

    public FlowJXPathSelectionList(Object model, String valuePath, String labelPath, Datatype datatype) {
        this.model = model;
        this.valuePath = valuePath;
        this.labelPath = labelPath;
        this.datatype = datatype;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        JXPathContext ctx = null;
        Iterator iter = null;
        if (this.model == null) {
            Object flowData = FlowHelper.getContextObject((Map)ContextHelper.getObjectModel((Context)this.context));
            if (flowData == null) {
                throw new SAXException("No flow data to produce selection list");
            }
            ctx = JXPathContext.newContext((Object)flowData);
            iter = ctx.iteratePointers(this.listPath);
        } else {
            ctx = JXPathContext.newContext((Object)this.model);
            iter = ctx.iteratePointers(".");
        }
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
        while (iter.hasNext()) {
            String stringValue = "";
            Object label = null;
            Pointer ptr = (Pointer)iter.next();
            if (ptr.getValue() != null) {
                JXPathContext itemCtx = ctx.getRelativeContext(ptr);
                Object value = itemCtx.getValue(this.valuePath);
                if (value != null) {
                    stringValue = this.datatype.convertToString(value, locale);
                }
                itemCtx.setLenient(true);
                label = itemCtx.getValue(this.labelPath);
                if (label == null) {
                    label = stringValue;
                }
            }
            AttributesImpl itemAttrs = new AttributesImpl();
            itemAttrs.addCDATAAttribute("value", stringValue);
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)itemAttrs);
            if (label != null) {
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
                if (label instanceof XMLizable) {
                    ((XMLizable)label).toSAX(contentHandler);
                } else {
                    String stringLabel = label.toString();
                    contentHandler.characters(stringLabel.toCharArray(), 0, stringLabel.length());
                }
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label");
            }
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list");
    }
}

