/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils.lucene;

import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.utils.database.Property;

import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Dec 17, 2002
 * Time: 1:16:48 PM
 * To change this template use Options | File Templates.
 */
public class LuceneDataField extends Property {


    /** Le type de champ dont il s'agit. */
    protected int fieldType;

    /** Indique s'il doit �tre retourn� dans la liste des r�sultats. */
    protected boolean store = true;//defaulted

    /**String representation of the field type. */
    public static final String FIELD_TYPE_WORD = "WORD";

    /**String representation of the field type. */
    public static final String FIELD_TYPE_FIELD = "FIELD";

    /**String representation of the field type. */
    public static final String FIELD_TYPE_DATE = "DATE";

    /**String representation of the field type. */
    public static final String FIELD_TYPE_UNINDEXED = "UNINDEXED";

    /** Field type "word". */
    public static final int WORD = 0;

    /** Field type "field" */
    public static final int FIELD = 1;

    /** Field type "date". */
    public static final int DATE = 2;

    /** Field type "unindexed".*/
    public static final int UNINDEXED = 3;

    /**Sets the type for this field
     *
     * @param type  The field type as a string from our configuration object (element in app.xconf)
     */
    public void setFieldType(String type) {
        if (type.equalsIgnoreCase(FIELD_TYPE_WORD)) {
            fieldType = WORD;
        } else if (type.equalsIgnoreCase(FIELD_TYPE_FIELD)) {
            fieldType = FIELD;
        } else if (type.equalsIgnoreCase(FIELD_TYPE_DATE)) {
            fieldType = DATE;
        } else if (type.equalsIgnoreCase(FIELD_TYPE_UNINDEXED)) {
            fieldType = UNINDEXED;
        } else
            fieldType = WORD;
    }

    public void setFieldType(boolean store, boolean index, boolean token) {
        setStore(store);
        if (index & !token) {
            fieldType = FIELD;
        } else if (!index & !token) {
            fieldType = UNINDEXED;
        } else if (index & token)
            fieldType = WORD;
    }

    /**
     *	Returns the type Name of the field.
     */
    public String getTypeName() {
        if (this.fieldType == WORD) return FIELD_TYPE_WORD.toLowerCase(/*this.locale*/);
        if (this.fieldType == FIELD) return FIELD_TYPE_FIELD.toLowerCase(/*this.locale*/);
        if (this.fieldType == DATE) return FIELD_TYPE_DATE.toLowerCase(/*this.locale*/);
        if (this.fieldType == UNINDEXED) return FIELD_TYPE_UNINDEXED.toLowerCase(/*this.locale*/);
        return null;
    }

    /**
     *	Returns the Lucene field for the search field.
     *
     * In the case of a field of type "date", if the contents can be interpreted
     * as a date it will be  inserted this way, if not it will be inserted like
     * a field of type "keyword".
     *
     *	@param content The field's content.
     */
    public org.apache.lucene.document.Field getLuceneField(String content) {
        switch (fieldType) {
            case DATE:
                // We will try to get a date
                Date date = fr.gouv.culture.sdx.utils.Date.parseDate(content);
                if (date != null)
                    return new org.apache.lucene.document.Field(name, DateField.dateToString(date), store, true, false, false);
                else
                    return new org.apache.lucene.document.Field(name, content, store, true, false, false);

            case FIELD:
                return new org.apache.lucene.document.Field(name, content, store, true, false, false);
            case WORD:
                return new org.apache.lucene.document.Field(name, content, store, true, true); //TODO: how to get the storeTermVector value from here ? -la
            case UNINDEXED:
                return new org.apache.lucene.document.Field(name, content, store, false, false, false);
            default:		// Shoud neved happen, but still we return a tokenized field but unstore
                return new org.apache.lucene.document.Field(name, content, false, true, true, false);
        }
    }


    public void setStore(boolean store) {
        this.store = store;
    }
}
