/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.exception.SDXException;

import java.io.File;
import java.net.URL;


public class BinaryDocument extends AbstractDocument {

    /**Le document XML auquel il est rattach�. */
    private String parentDocId;

    /** L'identificateur de ce document attach�. */
    private String docId;

    /** Le nom de fichier dont il s'agit. */
    private String filename;

    /** L'URL o� l'on trouve les donn�es */
    private URL sourceUrl;

    /** L'URL relative o� l'on trouve les donn�es */
    private String relativeUrl;

    /** La source de donn�es. */
    private File dataSource;

    /** Le document lui-m�me */
    private byte[] data;

    /** La longueur du contenu */
    private int length = -1;
    /** String representation of the default mimetype for our attached documents. */
    public static final String DEFAULT_MIMETYPE = "application/octet-stream";

    /**Gets the docType for the document*/
    public String getDocType() {
        return Document.DOCTYPE_BINARY;
    }

    /**Convenience constructor for document deletion*/
    public BinaryDocument() {
    }

    /** Builds a Binary document and set's the necessary fields
     *
     * @param docId     The document id
     * @param url       The url of this document
     * @param mimetype  The mimetype String
     * @throws SDXException
     */
    public BinaryDocument(String docId, URL url, String mimetype) throws SDXException {
        setId(docId);
        //setting the document mimetype
        setMimeType(mimetype);
        // set content
        setContent(url);
    }
    
}
