/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.store.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.BitSet;
import java.util.Enumeration;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.impl.AbstractReadWriteStore;

public abstract class AbstractFilesystemStore
extends AbstractReadWriteStore
implements Store,
ThreadSafe {
    protected File m_directoryFile;
    protected volatile String m_directoryPath;
    static BitSet charactersDontNeedingEncoding;
    static final int characterCaseDiff = 32;

    public void setDirectory(String directory) throws IOException {
        this.setDirectory(new File(directory));
    }

    public void setDirectory(File directory) throws IOException {
        this.m_directoryFile = directory;
        this.m_directoryPath = this.getFullFilename(this.m_directoryFile);
        this.m_directoryPath = this.m_directoryPath + File.separator;
        if (!this.m_directoryFile.exists() && !this.m_directoryFile.mkdir()) {
            throw new IOException("Error creating store directory '" + this.m_directoryPath + "': ");
        }
        if (!this.m_directoryFile.isDirectory()) {
            throw new IOException("'" + this.m_directoryPath + "' is not a directory");
        }
        if (!this.m_directoryFile.canRead() || !this.m_directoryFile.canWrite()) {
            throw new IOException("Directory '" + this.m_directoryPath + "' is not readable/writable");
        }
    }

    public String getDirectoryPath() {
        return this.m_directoryPath;
    }

    protected Object doGet(Object key) {
        File file = this.fileFromKey(key);
        if (file != null && file.exists()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found file: " + key);
            }
            try {
                return this.deserializeObject(file);
            }
            catch (Exception any) {
                this.getLogger().error("Error during deseralization.", (Throwable)any);
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("NOT Found file: " + key);
        }
        return null;
    }

    protected void doStore(Object key, Object value) throws IOException {
        File file = this.fileFromKey(key);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (value == null) {
            if (file.exists() && !file.delete()) {
                this.getLogger().error("File cannot be deleted: " + file.toString());
                return;
            }
            file.mkdir();
        } else if (value instanceof String) {
            this.serializeString(file, (String)value);
        } else {
            this.serializeObject(file, value);
        }
    }

    protected void doRemove(Object key) {
        File file = this.fileFromKey(key);
        if (file != null) {
            file.delete();
        }
    }

    protected void doClear() {
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            if (key == null) continue;
            this.remove(key);
        }
    }

    protected boolean doContainsKey(Object key) {
        File file = this.fileFromKey(key);
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    protected Enumeration doGetKeys() {
        FSEnumeration fSEnumeration = new FSEnumeration();
        this.addKeys(fSEnumeration, this.m_directoryFile);
        return fSEnumeration;
    }

    protected int doGetSize() {
        return this.countKeys(this.m_directoryFile);
    }

    protected void addKeys(FSEnumeration fSEnumeration, File directory) {
        int subStringBegin = this.m_directoryFile.getAbsolutePath().length() + 1;
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.addKeys(fSEnumeration, files[i]);
            } else {
                fSEnumeration.add(this.decode(files[i].getAbsolutePath().substring(subStringBegin)));
            }
            ++i;
        }
    }

    protected int countKeys(File directory) {
        int count = 0;
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            count = files[i].isDirectory() ? (count += this.countKeys(files[i])) : ++count;
            ++i;
        }
        return count;
    }

    protected File fileFromKey(Object key) {
        File file = new File(this.m_directoryFile, this.encode(key.toString()));
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return file;
    }

    public String getString(Object key) throws IOException {
        File file = this.fileFromKey(key);
        if (file != null) {
            return this.deserializeString(file);
        }
        return null;
    }

    public void free() {
    }

    protected void doFree() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObject(Object key) throws IOException, ClassNotFoundException {
        Sync sync = this.lock.writeLock();
        try {
            block5: {
                Object object;
                sync.acquire();
                try {
                    File file = this.fileFromKey(key);
                    if (file == null) break block5;
                    object = this.deserializeObject(file);
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    sync.release();
                    throw throwable;
                }
                sync.release();
                return object;
            }
            Object var6_7 = null;
            sync.release();
            {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected String decode(String filename) {
        if (filename.length() > 127) {
            int c = filename.length() / 127;
            int pos = c * 127;
            StringBuffer out = new StringBuffer(filename);
            while (pos > 0) {
                out.delete(pos, pos + 1);
                pos -= 127;
            }
            filename = out.toString();
        }
        return URLDecoder.decode(filename);
    }

    protected String encode(String s) {
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(32);
        OutputStreamWriter writer = new OutputStreamWriter(buf);
        int i = 0;
        while (i < s.length()) {
            block9: {
                char c = s.charAt(i);
                if (charactersDontNeedingEncoding.get(c)) {
                    out.append(c);
                } else {
                    try {
                        writer.write(c);
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block9;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        out.append('%');
                        char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ch = Character.forDigit(ba[j] & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
        int pos = 127;
        while (out.length() > pos) {
            out.insert(pos, File.separatorChar);
            pos += 127;
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serializeString(File file, String string) throws IOException {
        FileWriter fw = new FileWriter(file);
        try {
            fw.write(string);
            ((Writer)fw).flush();
            Object var5_4 = null;
            if (fw == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fw == null) throw throwable;
            ((Writer)fw).close();
            throw throwable;
        }
        ((Writer)fw).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String deserializeString(File file) throws IOException {
        char[] chr = new char[4096];
        StringBuffer buffer = new StringBuffer();
        FileReader reader = new FileReader(file);
        try {
            int len;
            while ((len = reader.read(chr)) > 0) {
                void var2_5;
                buffer.append(chr, 0, (int)var2_5);
            }
            Object var7_6 = null;
            if (reader == null) return buffer.toString();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        reader.close();
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serializeObject(File file, Object object) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(fos));
            oos.writeObject(object);
            oos.flush();
            Object var6_5 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fos == null) throw throwable;
            fos.close();
            throw throwable;
        }
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object deserializeObject(File file) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        Object object = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(fis));
            object = ois.readObject();
            Object var6_5 = null;
            if (fis == null) return object;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fis == null) throw throwable;
            fis.close();
            throw throwable;
        }
        fis.close();
        return object;
    }

    public String getFullFilename(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    static {
        characterCaseDiff = 32;
        charactersDontNeedingEncoding = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            charactersDontNeedingEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            charactersDontNeedingEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            charactersDontNeedingEncoding.set(i);
            ++i;
        }
        charactersDontNeedingEncoding.set(45);
        charactersDontNeedingEncoding.set(95);
        charactersDontNeedingEncoding.set(40);
        charactersDontNeedingEncoding.set(41);
    }

    final class FSEnumeration
    implements Enumeration {
        private String[] array = new String[16];
        private int index = 0;
        private int length = 0;

        FSEnumeration() {
        }

        public void add(String key) {
            if (this.length == this.array.length) {
                String[] newarray = new String[this.length + 16];
                System.arraycopy(this.array, 0, newarray, 0, this.array.length);
                this.array = newarray;
            }
            this.array[this.length] = key;
            ++this.length;
        }

        public boolean hasMoreElements() {
            return this.index < this.length;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                ++this.index;
                return this.array[this.index - 1];
            }
            return null;
        }
    }
}

