/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.IOException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.midi.xmidi.Utils;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMidiSerializer
extends AbstractSerializer {
    private static final String mimeType = "audio/x-midi";
    private final int OUTSIDE_XMIDI = 0;
    private final int INSIDE_XMIDI = 1;
    private final int INSIDE_CHUNK = 2;
    private final int INSIDE_MTHD = 3;
    private final int INSIDE_MTRK = 4;
    private final int INSIDE_DELTA = 5;
    private final int INSIDE_STATUS = 6;
    private final int INSIDE_DELTA_CHANNEL = 7;
    private final int INSIDE_STATUS_CHANNEL = 8;
    private int expectedBytes;
    private boolean preventDataWrite;
    private int state;
    private StringBuffer buffer;
    private boolean buffering = false;

    public void recycle() {
        this.preventDataWrite = false;
        this.state = 0;
        super.recycle();
    }

    public String getMimeType() {
        return mimeType;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (localName.equals("XMidi")) {
                if (this.state != 0) {
                    throw new SAXException("XMidi element not expected here");
                }
                this.state = 1;
                String version = atts.getValue("VERSION");
                if (version == null) {
                    throw new SAXException("XMidi element has no version attribute");
                }
                if (!version.equals("1.2")) {
                    throw new SAXException("XMidi element has wrong version: expecting 1.2, got " + version);
                }
                this.getLogger().debug("Found XMidi element, version " + version);
            } else if (localName.equals("CHUNK")) {
                if (this.state != 1) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                this.state = 2;
                this.writeString(atts.getValue("TYPE"), 4);
                Integer iLen = new Integer(atts.getValue("LENGTH"));
                this.writeFullWord(iLen);
                this.getLogger().debug("chunk type is: " + atts.getValue("TYPE") + " with length " + atts.getValue("LENGTH"));
            } else if (localName.equals("MThd")) {
                if (this.state != 1) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                this.state = 3;
                this.writeString(atts.getValue("TYPE"), 4);
                this.writeFullWord(Utils.stringToInt(atts.getValue("LENGTH")));
                this.getLogger().debug("we have MThd chunk; len = " + atts.getValue("LENGTH"));
            } else if (localName.equals("MTrk")) {
                if (this.state != 1) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                this.state = 4;
                this.writeString(atts.getValue("TYPE"), 4);
                this.writeFullWord(Utils.stringToInt(atts.getValue("LENGTH")));
                this.getLogger().debug("we have MTrk chunk; len = " + atts.getValue("LENGTH"));
            } else if (localName.equals("DELTA")) {
                if (this.state != 4) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                this.state = 5;
                String dtime = atts.getValue("DTIME");
                byte[] hdt = Utils.hexToBa(dtime, 4);
                byte[] dt = Utils.intToDelta(hdt);
                this.getLogger().debug("Delta: " + dtime + ", out = " + Utils.baToHex(dt, 0, dt.length - 1));
                this.output.write(dt);
            } else if (localName.equals("STATUS")) {
                if (this.state != 5) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                this.state = 6;
                String sval = atts.getValue("SVAL");
                this.writeHex(sval, 1);
                String sl = atts.getValue("SLEN");
                this.expectedBytes = Utils.stringToInt(sl);
                this.getLogger().debug("Status: " + sval + ", len = " + this.expectedBytes);
                if (sval.equals("FF")) {
                    String nmd = atts.getValue("SNMT");
                    this.writeHex(nmd, 1);
                    byte[] hdt = Utils.intToBa(this.expectedBytes, 4);
                    byte[] xdt = Utils.intToDelta(hdt);
                    this.output.write(xdt);
                    if (this.expectedBytes == 0) {
                        this.preventDataWrite = true;
                    }
                    this.getLogger().debug("Non-midi: " + nmd);
                } else if (sval.equals("F0")) {
                    byte[] hdt = Utils.intToBa(Utils.stringToInt(sl), 4);
                    this.output.write(Utils.intToDelta(hdt));
                    this.getLogger().debug("Sysex");
                } else if (sval.equals("F6") | sval.equals("F8") | sval.equals("FA") | sval.equals("FB") | sval.equals("FC") | sval.equals("FE")) {
                    this.preventDataWrite = true;
                    this.getLogger().debug("no data");
                }
            } else if (localName.equals("CHANNEL")) {
                if (this.state != 5 && this.state != 6) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                if (this.state == 5) {
                    this.state = 7;
                } else if (this.state == 6) {
                    this.state = 8;
                }
                this.getLogger().debug("Channel");
            } else if (localName.equals("NOTE_OFF")) {
                if (this.state != 7 && this.state != 8) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                String pitch = atts.getValue("PITCH");
                this.output.write(Utils.stringToInt(pitch));
                String vel = atts.getValue("VELOCITY");
                this.output.write(Utils.stringToInt(vel));
                this.getLogger().debug("Note off - " + pitch + ", " + vel);
            } else if (localName.equals("NOTE_ON")) {
                if (this.state != 7 && this.state != 8) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                String pitch = atts.getValue("PITCH");
                this.output.write(Utils.stringToInt(pitch));
                String vel = atts.getValue("VELOCITY");
                this.output.write(Utils.stringToInt(vel));
                this.getLogger().debug("Note on - " + pitch + ", " + vel);
            } else if (localName.equals("AFTER")) {
                if (this.state != 7 && this.state != 8) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                String pitch = atts.getValue("PITCH");
                this.output.write(Utils.stringToInt(pitch));
                String pres = atts.getValue("PRESSURE");
                this.output.write(Utils.stringToInt(pres));
                this.getLogger().debug("AFTER - " + pitch + ", " + pres);
            } else if (localName.equals("CONTROL")) {
                if (this.state != 7 && this.state != 8) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                String cnum = atts.getValue("NUMBER");
                this.output.write(Utils.stringToInt(cnum));
                String val = atts.getValue("VALUE");
                this.output.write(Utils.stringToInt(val));
                this.getLogger().debug("CONTROL - " + cnum + ", " + val);
            } else if (localName.equals("PROGRAM")) {
                if (this.state != 7 && this.state != 8) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                String patch = atts.getValue("NUMBER");
                this.output.write(Utils.stringToInt(patch));
                this.getLogger().debug("PATCH - " + patch);
            } else if (localName.equals("PRESSURE")) {
                if (this.state != 7 && this.state != 8) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                String amt = atts.getValue("AMOUNT");
                this.output.write(Utils.stringToInt(amt));
                this.getLogger().debug("PRESSURE - " + amt);
            } else if (localName.equals("WHEEL")) {
                int a;
                if (this.state != 7 && this.state != 8) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                String amt = atts.getValue("AMOUNT");
                int b = a = Utils.stringToInt(amt);
                int c = a;
                this.output.write(c >>= 7);
                this.output.write(b &= 0x7F);
                this.getLogger().debug("Wheel - " + a + ": (" + c + "," + a + ")");
            } else if (localName.equals("EDATA")) {
                if (this.state != 5 && this.state != 6) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                this.buffer = new StringBuffer();
                this.buffering = true;
                this.getLogger().debug("EDATA (element, not text)");
            } else if (localName.equals("FORMAT") || localName.equals("TRACKS") || localName.equals("PPNQ")) {
                if (this.state != 3) {
                    throw new SAXException(localName + " element not expected here, state = " + this.state);
                }
                this.buffer = new StringBuffer();
                this.buffering = true;
                this.getLogger().debug(localName + " element");
            } else {
                this.getLogger().debug("Found " + localName + ", in state " + this.state);
            }
        }
        catch (ProcessingException e) {
            throw new SAXException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (localName.equals("CHUNK")) {
                this.state = 1;
            } else if (localName.equals("MThd") || localName.equals("MTrk")) {
                this.state = 1;
            } else if (localName.equals("DELTA")) {
                this.state = 4;
            } else if (localName.equals("STATUS")) {
                this.state = 5;
            } else if (localName.equals("CHANNEL")) {
                if (this.state == 8) {
                    this.state = 6;
                } else if (this.state == 7) {
                    this.state = 5;
                }
            } else if (localName.equals("EDATA")) {
                if (!this.preventDataWrite) {
                    this.writeHex(this.buffer.toString(), this.expectedBytes);
                    this.getLogger().debug("EDATA: " + this.buffer.toString());
                } else {
                    this.preventDataWrite = false;
                }
                this.buffering = false;
            } else if (localName.equals("FORMAT")) {
                String typ = this.buffer.toString();
                int i = 0;
                while (i < typ.length()) {
                    if (typ.substring(i, i + 1).compareTo("0") < 0 | typ.substring(i, i + 1).compareTo("9") > 0) {
                        throw new ProcessingException("Invalid numeric midi format: " + typ);
                    }
                    ++i;
                }
                int midiFormat = Utils.stringToInt(typ);
                this.writeHalfWord(midiFormat);
                this.getLogger().debug("Format is " + midiFormat);
                this.buffering = false;
            } else if (localName.equals("TRACKS")) {
                String sNum = this.buffer.toString();
                Integer iNum = new Integer(sNum);
                this.writeHalfWord(iNum);
                this.getLogger().debug(iNum + " tracks");
                this.buffering = false;
            } else if (localName.equals("PPNQ")) {
                String sPNQ = this.buffer.toString();
                this.writeHex(sPNQ, 2);
                this.getLogger().debug("PPNQ is " + sPNQ);
                this.buffering = false;
            } else if (localName.equals("HEXDATA")) {
                this.writeHex(this.buffer.toString(), this.buffer.length() / 2);
                this.buffering = false;
            }
        }
        catch (ProcessingException e) {
            throw new SAXException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    void writeString(String s, int len) throws IOException, ProcessingException {
        int l = s.length();
        if (l != len) {
            throw new ProcessingException("writeString; string length (" + l + ") != expected length (" + len + ")");
        }
        this.output.write(s.getBytes());
    }

    void writeHex(String h, int len) throws ProcessingException, IOException {
        int l = h.length();
        int cnt = 0;
        int bs = 0;
        int bc = 0;
        int i = 0;
        while (i < l) {
            String s = h.substring(i, i + 1);
            int x = " \n\t\r".indexOf(s);
            if (x == -1) {
                int tmp = "0123456789ABCDEF".indexOf(s.toUpperCase());
                if (bc == 0) {
                    bs = tmp;
                } else if (bc == 1) {
                    bs <<= 4;
                    bs |= tmp;
                } else {
                    throw new ProcessingException("writeHex; internal error");
                }
                if (++bc >= 2) {
                    this.output.write(bs);
                    ++cnt;
                    bc = 0;
                }
            }
            ++i;
        }
        if (bc != 0) {
            throw new ProcessingException("un-even number of hex digits");
        }
        if (cnt != len) {
            throw new ProcessingException("writeHex count (" + cnt + ") != length (" + len + ")");
        }
    }

    void writeFullWord(int f) throws ProcessingException, IOException {
        byte[] b = Utils.intToBa(f, 4);
        this.output.write(b);
    }

    void writeHalfWord(int h) throws ProcessingException, IOException {
        byte[] b = Utils.intToBa(h, 2);
        this.output.write(b);
    }

    public void characters(char[] str, int arg1, int arg2) throws SAXException {
        if (this.buffering) {
            this.buffer.append(str, arg1, arg2);
        }
    }
}

