/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.javascript.fom.FOM_JavaScriptFlowHelper;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.garbage.Processor;
import org.apache.garbage.parser.Parser;
import org.apache.garbage.tree.Events;
import org.apache.garbage.tree.Tree;
import org.apache.garbage.tree.TreeException;
import org.mozilla.javascript.Scriptable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class GarbageGenerator
extends ServiceableGenerator {
    protected static Map cache = new HashMap();
    protected JXPathContext jxpathContext;
    protected Source source;

    public void recycle() {
        if (this.source != null) {
            this.resolver.release(this.source);
            this.source = null;
        }
        super.recycle();
        this.jxpathContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        if (src != null) {
            try {
                this.source = resolver.resolveURI(src);
            }
            catch (SourceException se) {
                throw SourceUtil.handle((String)("Error during resolving of '" + src + "'."), (SourceException)se);
            }
            long lastMod = this.source.getLastModified();
            String uri = this.source.getURI();
            Map map = cache;
            synchronized (map) {
                CacheEntry t = (CacheEntry)cache.get(uri);
                if (t != null && lastMod > t.compileTime) {
                    cache.remove(uri);
                }
            }
        }
        Object bean = FlowHelper.getContextObject((Map)objectModel);
        Scriptable kont = FOM_JavaScriptFlowHelper.getFOM_WebContinuation((Map)objectModel);
        this.setContext(bean, kont, FOM_JavaScriptFlowHelper.getFOM_Request((Map)objectModel), FOM_JavaScriptFlowHelper.getFOM_Response((Map)objectModel), FOM_JavaScriptFlowHelper.getFOM_Session((Map)objectModel), FOM_JavaScriptFlowHelper.getFOM_Context((Map)objectModel), parameters);
    }

    protected void setContext(Object contextObject, Object kont, Object request, Object response, Object session, Object context, Parameters parameters) {
        this.jxpathContext = JXPathContext.newContext((Object)contextObject);
        Variables varScope = this.jxpathContext.getVariables();
        varScope.declareVariable("flowContext", contextObject);
        varScope.declareVariable("continuation", kont);
        varScope.declareVariable("request", request);
        varScope.declareVariable("response", response);
        varScope.declareVariable("session", session);
        varScope.declareVariable("context", context);
        varScope.declareVariable("parameters", (Object)parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            CacheEntry t;
            Map map = cache;
            synchronized (map) {
                t = (CacheEntry)cache.get(this.source.getURI());
            }
            if (t == null) {
                t = new CacheEntry();
                t.compileTime = this.source.getLastModified();
                Parser parser = new Parser();
                InputSource is = new InputSource(this.source.getInputStream());
                is.setSystemId(this.source.getURI());
                t.tree = parser.parse(is);
                Map map2 = cache;
                synchronized (map2) {
                    cache.put(this.source.getURI(), t);
                }
            }
            new Processor((ContentHandler)this.xmlConsumer, (LexicalHandler)this.xmlConsumer).process((Events)t.tree, this.jxpathContext);
        }
        catch (TreeException exc) {
            throw new SAXParseException(exc.getMessage(), (Locator)((Object)exc), (Exception)((Object)exc));
        }
    }

    protected static class CacheEntry {
        Tree tree;
        long compileTime;

        protected CacheEntry() {
        }
    }
}

