/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.caching.validity.Event;
import org.apache.cocoon.caching.validity.EventFactory;
import org.apache.cocoon.caching.validity.EventValidity;
import org.apache.cocoon.caching.validity.NameValueEventFactory;
import org.apache.cocoon.caching.validity.NamedEventFactory;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public class EventCacheGenerator
extends ServiceableGenerator
implements Configurable,
CacheableProcessingComponent {
    public static final String NAME_VALUE_EVENT_TYPE = "name-value";
    public static final String EVENT_TYPE_DEFAULT = "named";
    public static final String NAMED_EVENT_TYPE = "named";
    public static final String FACTORY_CONF = "factory";
    public static final String FACTORY_NAME_CONF = "name";
    public static final String FACTORY_NAME_TYPE = "src";
    public static final String DELEGATE_PARAM = "delegate";
    public static final String EVENT_TYPE_PARAM = "event-type";
    private ServiceSelector m_generatorSelector;
    private Generator m_delegate;
    private Serializable m_key;
    private Event m_event;
    private Map m_types = new HashMap();

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.m_generatorSelector = (ServiceSelector)manager.lookup(Generator.ROLE + "Selector");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] factories = configuration.getChildren(FACTORY_CONF);
        int i = 0;
        while (i < factories.length) {
            Configuration child = factories[i];
            String name = child.getAttribute(FACTORY_NAME_CONF);
            String src = child.getAttribute(FACTORY_NAME_TYPE);
            try {
                EventFactory factory = (EventFactory)Class.forName(src).newInstance();
                this.m_types.put(name, factory);
            }
            catch (Exception e) {
                String message = "Unable to create EventFactory of type " + src;
                throw new ConfigurationException(message, (Throwable)e);
            }
            ++i;
        }
        if (!this.m_types.containsKey("named")) {
            this.m_types.put("named", new NamedEventFactory());
        }
        if (!this.m_types.containsKey(NAME_VALUE_EVENT_TYPE)) {
            this.m_types.put(NAME_VALUE_EVENT_TYPE, new NameValueEventFactory());
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String delegate = par.getParameter(DELEGATE_PARAM, null);
        if (delegate == null) {
            String message = "Required parameter 'delegate' is missing";
            throw new ProcessingException(message);
        }
        try {
            this.m_delegate = (Generator)this.m_generatorSelector.select((Object)delegate);
        }
        catch (ServiceException e) {
            String message = "Generator '" + delegate + "' could not be found.";
            throw new ProcessingException(message);
        }
        this.m_delegate.setup(resolver, objectModel, src, par);
        String eventType = par.getParameter(EVENT_TYPE_PARAM, "named");
        EventFactory factory = (EventFactory)this.m_types.get(eventType);
        if (factory == null) {
            throw new ProcessingException("No such type of event: " + eventType);
        }
        try {
            this.m_event = factory.createEvent(par);
        }
        catch (ParameterException e) {
            String message = "Failure creating Event";
            throw new ProcessingException("Failure creating Event", (Throwable)e);
        }
        this.m_key = SourceUtil.appendParameters((String)src, (Parameters)par);
    }

    public void setConsumer(XMLConsumer consumer) {
        this.m_delegate.setConsumer(consumer);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.m_delegate.generate();
    }

    public void recycle() {
        if (this.m_delegate != null) {
            this.m_generatorSelector.release((Object)this.m_delegate);
        }
        this.m_delegate = null;
        this.m_key = null;
        this.m_event = null;
        super.recycle();
    }

    public Serializable getKey() {
        return this.m_key;
    }

    public SourceValidity getValidity() {
        return new EventValidity(this.m_event);
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.m_generatorSelector);
            this.m_generatorSelector = null;
        }
        super.dispose();
    }
}

