/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.mail.MailSender;
import org.apache.cocoon.mail.datasource.FilePartDataSource;
import org.apache.cocoon.mail.datasource.SourceDataSource;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.excalibur.source.Source;

public class MailMessageSender
extends AbstractLogEnabled
implements MailSender,
Parameterizable,
Initializable,
Component {
    private MimeMessage message;
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private String subject;
    private String charset;
    private String src;
    private String srcMimeType;
    private String body;
    private List attachmentList;
    private Exception exception = null;
    private String smtpHost;

    public MailMessageSender() {
    }

    public MailMessageSender(String smtpHost) {
        smtpHost = smtpHost.trim();
        Properties properties = new Properties();
        Session session = Session.getDefaultInstance((Properties)properties);
        if ("null".equals(smtpHost)) {
            properties.put("mail.smtp.host", "127.0.0.1");
        } else {
            properties.put("mail.smtp.host", smtpHost);
        }
        this.message = new MimeMessage(session);
        this.attachmentList = new ArrayList();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void send(SourceResolver resolver) throws AddressException, MessagingException {
        block34: {
            sourcesList = new ArrayList<Source>();
            if (this.from == null) {
                throw new AddressException("no from address");
            }
            try {
                this.message.setFrom((Address)new InternetAddress(this.from));
            }
            catch (AddressException e) {
                throw new AddressException("invalid from address: " + this.from + ": " + e.getMessage());
            }
            if (this.to == null) {
                throw new AddressException("no to address");
            }
            try {
                this.message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to));
            }
            catch (AddressException e) {
                throw new AddressException("invalid to address: " + this.to + ": " + e.getMessage());
            }
            if (this.cc != null) {
                try {
                    this.message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.cc));
                }
                catch (AddressException e) {
                    throw new AddressException("invalid cc address: " + this.cc + ": " + e.getMessage());
                }
            }
            if (this.bcc != null) {
                try {
                    this.message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.bcc));
                }
                catch (AddressException e) {
                    throw new AddressException("invalid bcc address: " + this.bcc + ": " + e.getMessage());
                }
            }
            if (this.subject != null) {
                this.message.setSubject(this.subject);
            }
            this.message.setSentDate(new Date());
            a = null;
            try {
                block37: {
                    block35: {
                        block36: {
                            if (!this.attachmentList.isEmpty()) break block35;
                            if (this.src == null) break block36;
                            ds = null;
                            source = resolver.resolveURI(this.src);
                            sourcesList.add(source);
                            if (source.exists()) {
                                ds = new SourceDataSource(source, this.srcMimeType == null ? source.getMimeType() : this.srcMimeType, this.src.substring(this.src.lastIndexOf(47) + 1));
                            }
                            this.message.setDataHandler(new DataHandler(ds));
                            break block37;
                        }
                        if (this.body == null) break block37;
                        if (this.charset != null) {
                            this.message.setText(this.body, this.charset);
                        } else {
                            this.message.setText(this.body);
                        }
                        break block37;
                    }
                    multipart = new MimeMultipart();
                    bodypart = new MimeBodyPart();
                    multipart.addBodyPart((BodyPart)bodypart);
                    this.message.setContent((Multipart)multipart);
                    if (this.src != null) {
                        ds = null;
                        source = resolver.resolveURI(this.src);
                        sourcesList.add(source);
                        if (source.exists()) {
                            ds = new SourceDataSource(source, this.srcMimeType == null ? source.getMimeType() : this.srcMimeType, this.src.substring(this.src.lastIndexOf(47) + 1));
                        }
                        bodypart.setDataHandler(new DataHandler(ds));
                        bodypart.setFileName(ds.getName());
                    } else if (this.body != null) {
                        bodypart.setText(this.body);
                    }
                    i = this.attachmentList.iterator();
                    while (i.hasNext()) {
                        a = (Attachment)i.next();
                        ds /* !! */  = null;
                        if (a.isURL) {
                            name = (String)a.getObject();
                            src = resolver.resolveURI(name);
                            sourcesList.add(src);
                            if (src.exists()) {
                                ds /* !! */  = new SourceDataSource(src, a.getType(src.getMimeType()), a.getName(name.substring(name.lastIndexOf(47) + 1)));
                            }
                        } else if (a.getObject() instanceof Part) {
                            part = (Part)a.getObject();
                            ds /* !! */  = new FilePartDataSource(part, a.getType(part.getMimeType()), a.getName(part.getUploadName()));
                        } else {
                            throw new AddressException("Not yet supported: " + a.getObject());
                        }
                        bodypart = new MimeBodyPart();
                        bodypart.setDataHandler(new DataHandler((DataSource)ds /* !! */ ));
                        bodypart.setFileName(ds /* !! */ .getName());
                        multipart.addBodyPart((BodyPart)bodypart);
                    }
                }
                Transport.send((Message)this.message);
            }
            catch (MessagingException me) {
                throw new MessagingException(me.getMessage());
            }
            catch (MalformedURLException e) {
                throw new AddressException("Malformed attachment URL: " + a.getObject() + " error " + e.getMessage());
            }
            catch (IOException e) {
                throw new AddressException("IOException accessing attachment URL: " + a.getObject() + " error " + e.getMessage());
            }
            finally {
                if (sourcesList == null) break block34;
                j = sourcesList.iterator();
                ** while (j.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                resolver.release((Source)j.next());
                continue;
            }
        }
        throw var10_17;
    }

    public boolean sendIt(SourceResolver resolver) {
        boolean success = false;
        try {
            this.exception = null;
            this.send(resolver);
            success = true;
        }
        catch (Exception e) {
            this.exception = e;
        }
        return success;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setFrom(String from) {
        if (!"".equals(from) && !"null".equals(from)) {
            this.from = from.trim();
        }
    }

    public void setTo(String to) {
        if (!"".equals(to) && !"null".equals(to)) {
            this.to = to.trim();
        }
    }

    public void setCc(String cc) {
        if (!"".equals(cc) && !"null".equals(cc)) {
            this.cc = cc.trim();
        }
    }

    public void setBcc(String bcc) {
        if (!"".equals(bcc) && !"null".equals(bcc)) {
            this.bcc = bcc.trim();
        }
    }

    public void setCharset(String charset) {
        if (!"".equals(charset) && !"null".equals(charset)) {
            this.charset = charset.trim();
        }
    }

    public void setSubject(String subject) {
        if (!"".equals(subject) && !"null".equals(subject)) {
            this.subject = subject;
        }
    }

    public void setBody(String body) {
        if (!"".equals(body) && !"null".equals(body)) {
            this.body = body;
        }
    }

    public void setBodyFromSrc(String src) {
        if (!"".equals(src) && !"null".equals(src)) {
            this.src = src;
        }
    }

    public void setBodyFromSrcMimeType(String srcMimeType) {
        if (!"".equals(srcMimeType) && !"null".equals(srcMimeType)) {
            this.srcMimeType = srcMimeType;
        }
    }

    public void addAttachment(Object attachment) {
        if (attachment != null) {
            this.attachmentList.add(new Attachment(attachment));
        }
    }

    public void addAttachment(Object attachment, String type, String name) {
        if (attachment != null) {
            this.attachmentList.add(new Attachment(attachment, type, name));
        }
    }

    public void addAttachmentURL(String url) {
        if (url != null) {
            this.attachmentList.add(new Attachment(url, null, null, true));
        }
    }

    public void addAttachmentURL(String url, String type, String name) {
        if (url != null) {
            this.attachmentList.add(new Attachment(url, type, name, true));
        }
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.smtpHost = parameters.getParameter("smtp-host", null);
    }

    public void initialize() throws Exception {
        Properties properties = new Properties();
        Session session = Session.getDefaultInstance((Properties)properties);
        if (this.smtpHost == null || "null".equals(this.smtpHost)) {
            properties.put("mail.smtp.host", "127.0.0.1");
        } else {
            properties.put("mail.smtp.host", this.smtpHost);
        }
        this.message = new MimeMessage(session);
        this.attachmentList = new ArrayList();
    }

    public void setSmtpHost(String hostname) {
        this.smtpHost = hostname;
    }

    private class Attachment {
        private Object obj = null;
        private String type = null;
        private String name = null;
        protected boolean isURL = false;

        public Attachment(Object obj) {
            this(obj, null, null);
        }

        public Attachment(Object obj, String type, String name) {
            this(obj, type, name, false);
        }

        public Attachment(Object obj, String type, String name, boolean isURI) {
            this.obj = obj;
            this.type = type;
            this.name = name;
            this.isURL = isURI;
            if (this.isNullOrEmpty(this.type)) {
                this.type = null;
            }
            if (this.isNullOrEmpty(this.name)) {
                this.name = null;
            }
        }

        private boolean isNullOrEmpty(String str) {
            return str == null || "".equals(str) || "null".equals(str);
        }

        public boolean isURL() {
            return this.isURL;
        }

        public String getName(String name) {
            return this.name == null ? name : this.name;
        }

        public String getType(String type) {
            return this.type == null ? type : this.type;
        }

        public Object getObject() {
            return this.obj;
        }
    }
}

