/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Store;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.mail.MailCommandManager;

public class MailContext
extends DefaultContext
implements LogEnabled {
    public static final String SESSION_MAIL_CONTEXT = "mail-context";
    public static final String MAIL_SESSION_ENTRY = "mail-session";
    public static final String MAIL_STORE_ENTRY = "mail-store";
    public static final String MAIL_CURRENT_WORKING_FOLDER_ENTRY = "mail-current-working-folder";
    public static final String MAIL_CURRENT_WORKING_COMMAND_ENTRY = "mail-current-working-command";
    private Request request;
    private Logger logger;

    MailContext(Context parent) {
        super(parent);
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Object get(Object key) throws ContextException {
        String keyString = (String)key;
        String PARAM_PREFIX_ENTRY = "param:";
        String PARAM_INTEGER_PREFIX_ENTRY = "param-integer:";
        String PARAM_FOLDER_PREFIX_ENTRY = "param-folder:";
        if (keyString.startsWith("param:")) {
            String paramName = keyString.substring("param:".length());
            String paramValue = this.getParameter(paramName);
            if (paramValue == null) {
                String message = "No parameter " + String.valueOf(keyString) + " available.";
                throw new ContextException(message);
            }
            return paramValue;
        }
        if (keyString.startsWith("param-integer:")) {
            String paramName = keyString.substring("param-integer:".length());
            try {
                Integer paramValue = this.getParameterAsInteger(paramName);
                return paramValue;
            }
            catch (NumberFormatException nfe) {
                String message = "Cannot create Integer for parameter " + String.valueOf(keyString);
                throw new ContextException(message, (Throwable)nfe);
            }
        }
        if (keyString.startsWith("param-folder:")) {
            String paramName = keyString.substring("param-folder:".length());
            String folderName = this.getParameter(paramName);
            if (folderName == null) {
                try {
                    folderName = (String)super.get((Object)MAIL_CURRENT_WORKING_FOLDER_ENTRY);
                }
                catch (ContextException ce) {
                    String message = "No mail-current-working-folder entry available ";
                    this.getLogger().error(message);
                    throw new ContextException(message, (Throwable)ce);
                }
            }
            Folder folder = null;
            try {
                folder = (Folder)this.getFolder(folderName);
            }
            catch (ContextException ce) {
                Store store = (Store)this.get(MAIL_STORE_ENTRY);
                try {
                    if (!store.isConnected()) {
                        store.connect();
                    }
                    String DEFAULT_FOLDER_NAME = "~";
                    folder = folderName.equals("~") || folderName.length() == 0 ? store.getDefaultFolder() : store.getFolder(folderName);
                    this.putFolder(folder);
                }
                catch (MessagingException me) {
                    String message = "Cannot get folder " + String.valueOf(folderName);
                    throw new ContextException(message, (Throwable)ce);
                }
            }
            return folder;
        }
        return super.get(key);
    }

    public Folder getTheFolder(String entry) throws ContextException {
        Folder f;
        try {
            f = (Folder)this.get("param-folder:" + entry);
        }
        catch (Exception e) {
            String message = "Cannot get Folder object for " + String.valueOf(entry);
            throw new ContextException(message, (Throwable)e);
        }
        return f;
    }

    public Object getFolder(String folderName) throws ContextException {
        folderName = this.canoncializeFoldername(folderName);
        String key = "folder:" + folderName;
        this.getLogger().debug("Getting folder " + String.valueOf(key));
        Object o = super.get((Object)key);
        this.getLogger().debug("Successfully getting folder " + String.valueOf(key) + ": " + String.valueOf(o));
        return o;
    }

    public void removeStore() {
        try {
            this.getLogger().info("Remove store " + String.valueOf((Object)this));
            this.removeAllFolders();
            Map map = this.getContextData();
            Store store = (Store)map.remove(MAIL_STORE_ENTRY);
            if (store != null) {
                MailCommandManager.closeStore(store);
            }
        }
        catch (Exception e) {
            String message = "Cannot remove store";
            this.getLogger().error(message, (Throwable)e);
        }
    }

    public void removeAllFolders() {
        try {
            this.getLogger().info("Remove folders " + String.valueOf((Object)this));
            Map map = this.getContextData();
            Set entrySet = map.entrySet();
            Iterator i = entrySet.iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                String key = (String)me.getKey();
                if (!key.startsWith("folder:")) continue;
                Folder f = (Folder)me.getValue();
                MailCommandManager.closeFolder(f);
                i.remove();
            }
        }
        catch (Exception e) {
            String message = "Cannot remove all folders";
            this.getLogger().error(message, (Throwable)e);
        }
    }

    public void putFolder(Folder folder) throws ContextException {
        String folderName = folder.getFullName();
        folderName = this.canoncializeFoldername(folderName);
        String key = "folder:" + folderName;
        this.getLogger().debug("Putting folder key: " + String.valueOf(key) + " folder " + String.valueOf(folder));
        try {
            Object objRef = super.get((Object)key);
            if (objRef != null) {
                try {
                    Folder f = (Folder)objRef;
                    MailCommandManager.closeFolder(f);
                }
                catch (MessagingException me) {
                    String message = "Cannot close folder";
                    this.getLogger().warn(message, (Throwable)me);
                }
            }
        }
        catch (ContextException e) {
            // empty catch block
        }
        super.put((Object)key, (Object)folder);
    }

    public void putFolder(Folder[] folders) throws ContextException {
        int i = 0;
        while (i < folders.length) {
            this.putFolder(folders[i]);
            ++i;
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected String getParameter(String key) {
        String value = this.request.getParameter(key);
        return value;
    }

    protected Integer getParameterAsInteger(String key) {
        String value = this.request.getParameter(key);
        Integer i = new Integer(value);
        return i;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected String canoncializeFoldername(String fn) {
        return fn;
    }
}

