/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.cron;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.cron.ConfigurableCronJob;
import org.apache.cocoon.components.cron.ServiceableCronJob;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class TestCronJob
extends ServiceableCronJob
implements Configurable,
ConfigurableCronJob {
    public static final String PARAMETER_MESSAGE = "TestCronJob.Parameter.Message";
    public static final String PARAMETER_SLEEP = "TestCronJob.Parameter.Sleep";
    public static final String PARAMETER_PIPELINE = "TestCronJob.Parameter.Pipeline";
    private String m_msg;
    private int m_sleep;
    private String pipeline;

    public void configure(Configuration config) throws ConfigurationException {
        this.m_msg = config.getChild("msg").getValue("I was not configured");
        this.m_sleep = config.getChild("sleep").getValueAsInteger(11000);
        this.pipeline = config.getChild("pipeline").getValue("samples/hello-world/hello.xhtml");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(String name) {
        block9: {
            this.getLogger().info("CronJob " + name + " launched at " + new Date() + " with message '" + this.m_msg + "' and sleep timeout of " + this.m_sleep + "ms");
            SourceResolver resolver = null;
            Source src = null;
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                src = resolver.resolveURI("cocoon://" + this.pipeline);
                InputStream is = src.getInputStream();
                InputStreamReader reader = new InputStreamReader(is);
                StringBuffer sb = new StringBuffer();
                char[] b = new char[8192];
                while (true) {
                    void var8_10;
                    int n;
                    if ((n = reader.read(b)) <= 0) {
                        reader.close();
                        this.getLogger().info("Cronjob " + name + " called pipeline " + this.pipeline + " and received following content:\n" + sb.toString());
                        if (resolver == null) break block9;
                        break;
                    }
                    sb.append(b, 0, (int)var8_10);
                }
            }
            catch (Exception e) {
                try {
                    throw new CascadingRuntimeException("CronJob " + name + " raised an exception", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (resolver != null) {
                        resolver.release(src);
                        this.manager.release((Object)resolver);
                        resolver = null;
                        src = null;
                    }
                    throw throwable;
                }
            }
            resolver.release(src);
            this.manager.release((Object)resolver);
            resolver = null;
            src = null;
        }
        try {
            Thread.sleep(this.m_sleep);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        this.getLogger().info("CronJob " + name + " finished at " + new Date() + " with message '" + this.m_msg + "' and sleep timeout of " + this.m_sleep + "ms");
    }

    public void setup(Parameters params, Map objects) {
        if (null != params) {
            this.m_msg = params.getParameter(PARAMETER_MESSAGE, this.m_msg);
            this.m_sleep = params.getParameterAsInteger(PARAMETER_SLEEP, this.m_sleep);
            this.pipeline = params.getParameter(PARAMETER_PIPELINE, this.pipeline);
        }
    }
}

