/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;

public class IndexSearcher
extends Searcher {
    IndexReader reader;
    private boolean closeReader;

    public IndexSearcher(String path) throws IOException {
        this(IndexReader.open(path), true);
    }

    public IndexSearcher(Directory directory) throws IOException {
        this(IndexReader.open(directory), true);
    }

    public IndexSearcher(IndexReader r) {
        this(r, false);
    }

    private IndexSearcher(IndexReader r, boolean closeReader) {
        this.reader = r;
        this.closeReader = closeReader;
    }

    public void close() throws IOException {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    public Document doc(int i) throws IOException {
        return this.reader.document(i);
    }

    public int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    public TopDocs search(Query query, Filter filter, int nDocs) throws IOException {
        Scorer scorer = query.weight(this).scorer(this.reader);
        if (scorer == null) {
            return new TopDocs(0, new ScoreDoc[0]);
        }
        final BitSet bits = filter != null ? filter.bits(this.reader) : null;
        final HitQueue hq = new HitQueue(nDocs);
        final int[] totalHits = new int[1];
        scorer.score(new HitCollector(){

            public final void collect(int doc, float score) {
                if (score > 0.0f && (bits == null || bits.get(doc))) {
                    totalHits[0] = totalHits[0] + 1;
                    hq.insert(new ScoreDoc(doc, score));
                }
            }
        });
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)hq.pop();
        }
        return new TopDocs(totalHits[0], scoreDocs);
    }

    public TopFieldDocs search(Query query, Filter filter, int nDocs, Sort sort) throws IOException {
        Scorer scorer = query.weight(this).scorer(this.reader);
        if (scorer == null) {
            return new TopFieldDocs(0, new ScoreDoc[0], sort.fields);
        }
        final BitSet bits = filter != null ? filter.bits(this.reader) : null;
        final FieldSortedHitQueue hq = new FieldSortedHitQueue(this.reader, sort.fields, nDocs);
        final int[] totalHits = new int[1];
        scorer.score(new HitCollector(){

            public final void collect(int doc, float score) {
                if (score > 0.0f && (bits == null || bits.get(doc))) {
                    totalHits[0] = totalHits[0] + 1;
                    hq.insert(new FieldDoc(doc, score));
                }
            }
        });
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = hq.fillFields((FieldDoc)hq.pop());
        }
        return new TopFieldDocs(totalHits[0], scoreDocs, hq.getFields());
    }

    public void search(Query query, Filter filter, final HitCollector results) throws IOException {
        Scorer scorer;
        HitCollector collector = results;
        if (filter != null) {
            final BitSet bits = filter.bits(this.reader);
            collector = new HitCollector(){

                public final void collect(int doc, float score) {
                    if (bits.get(doc)) {
                        results.collect(doc, score);
                    }
                }
            };
        }
        if ((scorer = query.weight(this).scorer(this.reader)) == null) {
            return;
        }
        scorer.score(collector);
    }

    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this.reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this.reader);
        }
        return query;
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return query.weight(this).explain(this.reader, doc);
    }
}

