/*
 * Decompiled with CFR 0.152.
 */
package com.ryangrier.ant;

import com.ryangrier.ant.ManifestFile;
import com.ryangrier.ant.TaskTools;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class BuildUpdate
extends Task {
    private static final String BUILD_UPDATE_VERSION = "1.3.0";
    private File srcdir;
    private String variablename = "build";
    private String antPropertyName = "VersionTool_Build";
    private String classname;
    private File classFile;
    private Vector manifestFiles = new Vector();
    private String fileContents;
    private String propertyName = null;
    private boolean debug = false;

    public void execute() throws BuildException {
        if (null == this.srcdir) {
            throw new BuildException("The srcdir variable cannot be null.");
        }
        if (null == this.classname) {
            throw new BuildException("The classname variable cannot be null.");
        }
        this.classFile = TaskTools.getFilePathFromClassName(this.srcdir, this.classname);
        if (this.classFile.exists()) {
            try {
                this.fileContents = TaskTools.readFile(this.classFile);
                String currentVersion = TaskTools.findVariableNameValueInClassFile(this.fileContents, this.variablename);
                if (currentVersion.length() < 1) {
                    throw new BuildException("Cannot find the variable : " + this.variablename);
                }
                String newVersion = this.getNewVersion(currentVersion);
                this.fileContents = TaskTools.replaceOldVersion(this.fileContents, currentVersion, newVersion);
                if (this.debug) {
                    System.out.println("Updating " + this.classFile.getName() + " from build " + currentVersion + " to build " + newVersion);
                }
                TaskTools.writeFile(this.classFile, this.fileContents.getBytes());
                this.getProject().setNewProperty(this.antPropertyName, newVersion);
                if (null != this.propertyName) {
                    this.getProject().setNewProperty(this.propertyName, newVersion);
                }
                this.updateManifestFiles(newVersion);
            }
            catch (Exception ex) {
                throw new BuildException(ex.toString());
            }
        } else {
            throw new BuildException("The File: " + this.classFile.getPath() + " does not exist.");
        }
    }

    public void setSrcdir(File srcdir) {
        this.srcdir = srcdir;
    }

    public void addManifestFile(ManifestFile manifestFile) {
        this.manifestFiles.add(manifestFile);
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setVariablename(String variablename) {
        this.variablename = variablename;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    private String getNewVersion(String currentVersion) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date today = new Date();
        String newBuildDate = formatter.format(today);
        int version = Integer.parseInt(currentVersion.substring(currentVersion.length() - 2));
        String oldBuildDate = currentVersion.substring(0, currentVersion.length() - 2);
        if (oldBuildDate.equals(newBuildDate)) {
            sb.append(newBuildDate);
            String versionString = new String(String.valueOf(version + 1));
            if (versionString.length() < 2) {
                sb.append("0");
            }
            sb.append(versionString);
        } else {
            sb.append(newBuildDate);
            sb.append("01");
        }
        return sb.toString();
    }

    private void updateManifestFiles(String newVersion) throws Exception {
        Enumeration enumeration = this.manifestFiles.elements();
        while (enumeration.hasMoreElements()) {
            ManifestFile manifest = (ManifestFile)enumeration.nextElement();
            manifest.execute(newVersion);
        }
    }

    public static void main(String[] args) {
        System.out.println("BuildUpdate Version: 1.3.0");
    }
}

