/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.batik.ext.awt.geom.RectListManager;
import org.apache.batik.gvt.renderer.ImageRenderer;

public class RepaintManager {
    static final int COPY_OVERHEAD = 1000;
    static final int COPY_LINE_OVERHEAD = 10;
    protected ImageRenderer renderer;

    public RepaintManager(ImageRenderer imageRenderer) {
        this.renderer = imageRenderer;
    }

    public Collection updateRendering(Collection collection) throws InterruptedException {
        Object object;
        this.renderer.flush(collection);
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(collection.size());
        AffineTransform affineTransform = this.renderer.getTransform();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (Shape)iterator.next();
            object = affineTransform.createTransformedShape((Shape)object);
            Rectangle2D rectangle2D = object.getBounds2D();
            int n = (int)Math.floor(rectangle2D.getX());
            int n2 = (int)Math.floor(rectangle2D.getY());
            int n3 = (int)Math.ceil(rectangle2D.getX() + rectangle2D.getWidth());
            int n4 = (int)Math.ceil(rectangle2D.getY() + rectangle2D.getHeight());
            Rectangle rectangle = new Rectangle(n - 1, n2 - 1, n3 - n + 3, n4 - n2 + 3);
            arrayList.add(rectangle);
        }
        object = null;
        try {
            object = new RectListManager(arrayList);
            ((RectListManager)object).mergeRects(1000, 10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.renderer.repaint((RectListManager)object);
        return object;
    }

    public void setupRenderer(AffineTransform affineTransform, boolean bl, Shape shape, int n, int n2) {
        this.renderer.setTransform(affineTransform);
        this.renderer.setDoubleBuffered(bl);
        this.renderer.updateOffScreen(n, n2);
        this.renderer.clearOffScreen();
    }

    public BufferedImage getOffScreen() {
        return this.renderer.getOffScreen();
    }
}

