/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.components;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.webapps.session.ContextManager;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class ContextInputModule
implements ThreadSafe,
Serviceable,
Disposable,
InputModule {
    protected ServiceManager manager;
    protected ContextManager contextManager;

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (name == null) {
            return null;
        }
        int pos = name.indexOf(47);
        if (pos != -1) {
            String contextName = name.substring(0, pos);
            String path = name.substring(pos);
            try {
                SessionContext context = this.contextManager.getContext(contextName);
                if (context != null) {
                    DocumentFragment frag = context.getXML(path);
                    return DOMUtil.getValueOfNode((Node)frag);
                }
            }
            catch (ProcessingException pe) {
                throw new ConfigurationException("Unable to get information from context.", (Throwable)pe);
            }
        }
        return null;
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return null;
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object value = this.getAttribute(name, modeConf, objectModel);
        if (value != null) {
            return new Object[]{value};
        }
        return null;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.contextManager = (ContextManager)this.manager.lookup(ContextManager.ROLE);
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.contextManager);
            this.contextManager = null;
            this.manager = null;
        }
    }
}

