/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portlet.multipart;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.portlet.ActionRequest;
import org.apache.cocoon.portlet.multipart.MultipartActionRequest;
import org.apache.cocoon.servlet.multipart.MultipartException;
import org.apache.cocoon.servlet.multipart.MultipartParser;

public class RequestFactory {
    private boolean saveUploadedFilesToDisk;
    private File uploadDirectory;
    private boolean allowOverwrite;
    private boolean silentlyRename;
    private String defaultCharEncoding;
    private int maxUploadSize;

    public RequestFactory(boolean saveUploadedFilesToDisk, File uploadDirectory, boolean allowOverwrite, boolean silentlyRename, int maxUploadSize, String defaultCharEncoding) {
        this.saveUploadedFilesToDisk = saveUploadedFilesToDisk;
        this.uploadDirectory = uploadDirectory;
        this.allowOverwrite = allowOverwrite;
        this.silentlyRename = silentlyRename;
        this.maxUploadSize = maxUploadSize;
        this.defaultCharEncoding = defaultCharEncoding;
    }

    public ActionRequest getServletRequest(ActionRequest request) throws IOException, MultipartException {
        ActionRequest req = request;
        String contentType = request.getContentType();
        if (contentType != null && contentType.toLowerCase().indexOf("multipart/form-data") > -1) {
            if (request.getContentLength() > this.maxUploadSize) {
                throw new IOException("Content length exceeds maximum upload size.");
            }
            String charEncoding = request.getCharacterEncoding();
            if (charEncoding == null || charEncoding.equals("")) {
                charEncoding = this.defaultCharEncoding;
            }
            MultipartParser parser = new MultipartParser(this.saveUploadedFilesToDisk, this.uploadDirectory, this.allowOverwrite, this.silentlyRename, this.maxUploadSize, charEncoding);
            Hashtable parts = parser.getParts(request.getContentLength(), request.getContentType(), request.getPortletInputStream());
            req = new MultipartActionRequest(request, parts);
        }
        return req;
    }
}

