/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.portlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.portlet.PortletContext;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.PermanentRedirector;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.portlet.ActionRequest;
import org.apache.cocoon.environment.portlet.ActionResponse;
import org.apache.cocoon.environment.portlet.PortletObjectModelHelper;
import org.apache.cocoon.environment.portlet.PortletRequest;
import org.apache.cocoon.environment.portlet.PortletResponse;
import org.apache.cocoon.environment.portlet.RenderRequest;
import org.apache.cocoon.environment.portlet.RenderResponse;

public class PortletEnvironment
extends AbstractEnvironment
implements Redirector,
PermanentRedirector {
    public static final String PARAMETER_PATH_INFO = "cocoon-portlet-path";
    public static final String HEADER_PORTLET_MODE = "X-Portlet-Mode";
    public static final String HEADER_WINDOW_STATE = "X-Window-State";
    public static final String HEADER_PORTLET_TITLE = "X-Portlet-Title";
    public static final String SESSION_APPLICATION_SCOPE = "portlet-application-";
    private PortletRequest request;
    private PortletResponse response;
    private Context context;
    private String contentType;
    private boolean hasRedirected;

    public PortletEnvironment(String servletPath, String uri, String root, javax.portlet.ActionRequest request, javax.portlet.ActionResponse response, PortletContext portletContext, Context context, String containerEncoding, String defaultFormEncoding) throws MalformedURLException, IOException {
        super(uri, null, root, null);
        String pathInfo = request.getParameter(PARAMETER_PATH_INFO);
        this.request = new ActionRequest(servletPath, pathInfo, request, this);
        this.request.setCharacterEncoding(defaultFormEncoding);
        this.request.setContainerEncoding(containerEncoding);
        this.response = new ActionResponse(response, request.getPreferences(), (ActionRequest)this.request, uri);
        this.context = context;
        this.setView(AbstractEnvironment.extractView((Request)this.request));
        this.setAction(AbstractEnvironment.extractAction((Request)this.request));
        this.initObjectModel((javax.portlet.PortletRequest)request, (javax.portlet.PortletResponse)response, portletContext);
    }

    public PortletEnvironment(String servletPath, String uri, String root, javax.portlet.RenderRequest request, javax.portlet.RenderResponse response, PortletContext portletContext, Context context, String containerEncoding, String defaultFormEncoding) throws MalformedURLException, IOException {
        super(uri, null, root, null);
        String pathInfo = request.getParameter(PARAMETER_PATH_INFO);
        this.request = new RenderRequest(servletPath, pathInfo, request, this);
        this.request.setCharacterEncoding(defaultFormEncoding);
        this.request.setContainerEncoding(containerEncoding);
        this.response = new RenderResponse(response, request.getPreferences());
        this.context = context;
        this.setView(AbstractEnvironment.extractView((Request)this.request));
        this.setAction(AbstractEnvironment.extractAction((Request)this.request));
        this.initObjectModel((javax.portlet.PortletRequest)request, (javax.portlet.PortletResponse)response, portletContext);
    }

    private void initObjectModel(javax.portlet.PortletRequest portletRequest, javax.portlet.PortletResponse portletResponse, PortletContext portletContext) {
        this.objectModel.put("request", this.request);
        this.objectModel.put("response", this.response);
        this.objectModel.put("context", this.context);
        PortletObjectModelHelper.setPortletRequest(this.objectModel, portletRequest);
        PortletObjectModelHelper.setPortletResponse(this.objectModel, portletResponse);
        PortletObjectModelHelper.setPortletContext(this.objectModel, portletContext);
    }

    public void redirect(boolean sessionmode, String newURL) throws IOException {
        this.hasRedirected = true;
        if (sessionmode) {
            String s;
            if (this.getLogger().isDebugEnabled() && (s = this.request.getRequestedSessionId()) != null) {
                this.getLogger().debug("Session ID in request = " + s + (this.request.isRequestedSessionIdValid() ? " (valid)" : " (invalid)"));
            }
            Session session = this.request.getSession(true);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Session ID = " + session.getId());
            }
        }
        String redirect = newURL;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Sending redirect to '" + redirect + "'");
        }
        this.response.sendRedirect(redirect);
    }

    public void permanentRedirect(boolean sessionmode, String newURL) throws IOException {
        this.redirect(sessionmode, newURL);
    }

    public boolean hasRedirected() {
        return this.hasRedirected;
    }

    public void setStatus(int statusCode) {
    }

    public void sendStatus(int sc) {
        throw new AbstractMethodError("Not Implemented");
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentLength(int length) {
    }

    public boolean isResponseModified(long lastModified) {
        return true;
    }

    public void setResponseIsNotModified() {
    }

    public boolean tryResetResponse() throws IOException {
        if (!super.tryResetResponse()) {
            try {
                if (!this.response.isCommitted()) {
                    this.response.reset();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Response successfully reset");
                    }
                    return true;
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Problem resetting response", (Throwable)e);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Response wasn't reset");
            }
            return false;
        }
        return true;
    }

    public OutputStream getOutputStream(int bufferSize) throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.response.getOutputStream();
        }
        return super.getOutputStream(bufferSize);
    }

    public boolean isExternal() {
        return true;
    }
}

