/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.RemoteUtils;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheServiceAdmin;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServer;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerAttributes;
import org.apache.jcs.engine.behavior.ICacheServiceAdmin;

public class RemoteCacheServerFactory
implements IRemoteCacheConstants {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServerFactory == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServerFactory = RemoteCacheServerFactory.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheServerFactory")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServerFactory));
    private static RemoteCacheServer instance;
    private static String serviceName;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServerFactory;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer;

    private RemoteCacheServerFactory() {
    }

    public static void startup(String host, int port, String propFile) throws IOException, NotBoundException {
        if (instance != null) {
            throw new IllegalArgumentException("Server already started.");
        }
        Class clazz = class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer = RemoteCacheServerFactory.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheServer")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer;
        synchronized (clazz) {
            if (instance != null) {
                return;
            }
            RemoteCacheServerAttributes rcsa = new RemoteCacheServerAttributes();
            rcsa.setConfigFileName(propFile);
            Properties prop = RemoteUtils.loadProps(propFile);
            String servicePortStr = prop.getProperty("remote.cache.service.port");
            int servicePort = -1;
            try {
                servicePort = Integer.parseInt(servicePortStr);
                rcsa.setServicePort(servicePort);
                log.debug((Object)("Remote cache service uses port number " + servicePort + "."));
            }
            catch (NumberFormatException ignore) {
                log.debug((Object)"Remote cache service port property remote.cache.service.port not specified.  An anonymous port will be used.");
            }
            String lccStr = prop.getProperty("remote.cluster.LocalClusterConsistency");
            if (lccStr == null) {
                lccStr = "true";
            }
            boolean lcc = Boolean.valueOf(lccStr);
            rcsa.setLocalClusterConsistency(lcc);
            String acgStr = prop.getProperty("remote.cluster.AllowClusterGet");
            if (acgStr == null) {
                acgStr = "true";
            }
            boolean acg = Boolean.valueOf(acgStr);
            rcsa.setAllowClusterGet(acg);
            instance = new RemoteCacheServer(rcsa);
            if (host == null) {
                host = "";
            }
            serviceName = prop.getProperty("remote.cache.service.name", IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL).trim();
            log.debug((Object)("main> binding server to " + host + ":" + port + " with the name " + serviceName));
            try {
                Naming.rebind("//" + host + ":" + port + "/" + serviceName, instance);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex.getMessage() + "; host=" + host + ", port=" + port);
            }
        }
    }

    static void shutdownImpl(String host, int port) throws IOException {
        if (instance == null) {
            return;
        }
        Class clazz = class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer = RemoteCacheServerFactory.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheServer")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer;
        synchronized (clazz) {
            if (instance == null) {
                return;
            }
            log.debug((Object)("Unbinding host=" + host + ", port=" + port + ", serviceName=" + serviceName));
            try {
                Naming.unbind("//" + host + ":" + port + "/" + serviceName);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex.getMessage() + "; host=" + host + ", port=" + port + ", serviceName=" + serviceName);
            }
            catch (NotBoundException ex) {
                // empty catch block
            }
            instance.release();
            instance = null;
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        int port;
        Properties prop;
        Properties properties = prop = args.length > 0 ? RemoteUtils.loadProps(args[args.length - 1]) : new Properties();
        if (args.length > 0 && args[0].toLowerCase().indexOf("-shutdown") != -1) {
            String serviceName = prop.getProperty("remote.cache.service.name", IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL).trim();
            String registry = "//:1099/" + serviceName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("looking up server " + registry));
            }
            Remote obj = Naming.lookup(registry);
            if (log.isDebugEnabled()) {
                log.debug((Object)"server found");
            }
            ICacheServiceAdmin admin = (ICacheServiceAdmin)((Object)obj);
            try {
                admin.shutdown();
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            log.debug((Object)"done.");
            System.exit(0);
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-stats") != -1) {
            log.debug((Object)"getting cache stats");
            try {
                int port2 = 1099;
                if (args.length > 1) {
                    port2 = Integer.parseInt(args[1]);
                }
                String serviceName = prop.getProperty("remote.cache.service.name", IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL).trim();
                String registry = "//:" + port2 + "/" + serviceName;
                log.debug((Object)("looking up server " + registry));
                Remote obj = Naming.lookup(registry);
                log.debug((Object)"server found");
                log.debug((Object)("obj = " + obj));
                IRemoteCacheServiceAdmin admin = (IRemoteCacheServiceAdmin)obj;
                try {
                    log.debug((Object)admin.getStats());
                }
                catch (Exception es) {
                    log.error((Object)es);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            log.debug((Object)"done.");
            System.exit(0);
        }
        try {
            port = Integer.parseInt(prop.getProperty("registry.port"));
        }
        catch (NumberFormatException ex) {
            port = 1099;
        }
        String host = prop.getProperty("registry.host");
        if (host == null || host.trim().equals("") || host.trim().equals("localhost")) {
            log.debug((Object)"main> creating registry on the localhost");
            port = RemoteUtils.createRegistry(port);
        }
        log.debug((Object)"main> starting up RemoteCacheServer");
        RemoteCacheServerFactory.startup(host, port, args.length > 0 ? args[0] : null);
        log.debug((Object)"main> done");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

