/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.symbol;

import java.io.Serializable;
import net.sourceforge.chaperon.model.symbol.Nonterminal;
import net.sourceforge.chaperon.model.symbol.Symbol;
import net.sourceforge.chaperon.model.symbol.SymbolCollection;
import net.sourceforge.chaperon.model.symbol.SymbolList;
import net.sourceforge.chaperon.model.symbol.Terminal;

public class SymbolSet
implements SymbolCollection,
Serializable,
Cloneable {
    private int capacityIncrement = 100;
    private int elementCount = 0;
    private Symbol[] list = new Symbol[10];

    public boolean addSymbol(Symbol symbol) {
        int index = this.indexOf(symbol);
        if (index == -1) {
            this.ensureCapacity(this.elementCount + 1);
            this.list[this.elementCount] = symbol;
            ++this.elementCount;
            return true;
        }
        return false;
    }

    public boolean addSymbol(SymbolCollection collection) {
        if (collection == null) {
            throw new NullPointerException("Symbol collection is null");
        }
        boolean changed = false;
        int i = 0;
        while (i < collection.getSymbolCount()) {
            changed |= this.addSymbol(collection.getSymbol(i));
            ++i;
        }
        return changed;
    }

    public void removeSymbol(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        --this.elementCount;
        if (index < this.elementCount) {
            System.arraycopy(this.list, index + 1, this.list, index, this.elementCount - index);
        }
    }

    public void removeSymbol(Symbol symbol) {
        if (symbol == null) {
            throw new NullPointerException("Symbol is null");
        }
        int i = this.elementCount - 1;
        while (i >= 0) {
            if (symbol.equals(this.list[i])) {
                this.removeSymbol(i);
            }
            --i;
        }
    }

    public void setSymbol(int index, Symbol symbol) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (symbol == null) {
            throw new NullPointerException("Symbol is null");
        }
        this.list[index] = symbol;
        if (this.contains(symbol) && !this.getSymbol(index).equals(symbol)) {
            throw new IllegalArgumentException("Set already contains the symbol");
        }
        this.list[index] = symbol;
    }

    public Symbol getSymbol(int index) {
        if (index < 0 && index >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.list[index];
    }

    public Symbol getSymbol(String name) {
        int index = this.indexOf(name);
        if (index >= 0) {
            return this.list[index];
        }
        return null;
    }

    public int getSymbolCount() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public int indexOf(Symbol symbol) {
        if (symbol == null) {
            throw new NullPointerException("Symbol is null");
        }
        int i = 0;
        while (i < this.elementCount) {
            if (this.list[i].equals(symbol)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String name) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        int i = 0;
        while (i < this.elementCount) {
            if (this.list[i].getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean contains(Symbol symbol) {
        if (symbol == null) {
            throw new NullPointerException("Symbol is null");
        }
        int i = 0;
        while (i < this.elementCount) {
            if (this.list[i].equals(symbol)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(String name) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        int i = 0;
        while (i < this.elementCount) {
            if (this.list[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(SymbolCollection collection) {
        if (collection == null) {
            throw new NullPointerException("Set is null");
        }
        int i = 0;
        while (i < collection.getSymbolCount()) {
            if (!this.contains(collection.getSymbol(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void clear() {
        this.elementCount = 0;
    }

    public SymbolSet getTerminals() {
        SymbolSet set = new SymbolSet();
        int i = 0;
        while (i < this.elementCount) {
            Symbol symbol = this.list[i];
            if (symbol instanceof Terminal) {
                set.addSymbol(symbol);
            }
            ++i;
        }
        return set;
    }

    public SymbolSet getNonterminals() {
        SymbolSet set = new SymbolSet();
        int i = 0;
        while (i < this.elementCount) {
            Symbol symbol = this.list[i];
            if (symbol instanceof Nonterminal) {
                set.addSymbol(symbol);
            }
            ++i;
        }
        return set;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SymbolSet) {
            SymbolSet set = (SymbolSet)o;
            if (this.getSymbolCount() != set.getSymbolCount()) {
                return false;
            }
            int i = 0;
            while (i < set.getSymbolCount()) {
                if (!this.contains(set.getSymbol(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.elementCount) {
            buffer.append(this.list[i].toString());
            if (i < this.elementCount - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        return buffer.toString();
    }

    public Object clone() {
        SymbolList clone = new SymbolList();
        int i = 0;
        while (i < this.getSymbolCount()) {
            clone.addSymbol(this.getSymbol(i));
            ++i;
        }
        return clone;
    }

    private void ensureCapacity(int minCapacity) {
        if (this.list.length >= minCapacity) {
            return;
        }
        int newCapacity = this.list.length + this.capacityIncrement;
        if (this.capacityIncrement <= 0) {
            newCapacity = this.list.length * 2;
        }
        Symbol[] newArray = new Symbol[Math.max(newCapacity, minCapacity)];
        System.arraycopy(this.list, 0, newArray, 0, this.list.length);
        this.list = newArray;
    }
}

