/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.authentication.configuration;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.webapps.authentication.configuration.HandlerConfiguration;
import org.apache.excalibur.source.SourceParameters;

public final class ApplicationConfiguration
implements Serializable {
    private String name;
    private String loadResource;
    private String saveResource;
    private SourceParameters loadResourceParameters;
    private SourceParameters saveResourceParameters;
    private boolean loadOnDemand = false;
    private HandlerConfiguration handler;
    private Map configurations;
    private boolean saveOnLogout = false;

    public ApplicationConfiguration(HandlerConfiguration handler, String name) throws ProcessingException {
        this.handler = handler;
        this.name = name;
        if (name.indexOf(95) != -1 || name.indexOf(58) != -1 || name.indexOf(47) != -1) {
            throw new ProcessingException("application name must not contain one of the characters ':','_' or '/'.");
        }
        this.configurations = new HashMap(3, 2.0f);
    }

    public void configure(Configuration appconf) throws ConfigurationException {
        Configuration[] configurations;
        Configuration child = null;
        this.loadOnDemand = appconf.getAttributeAsBoolean("loadondemand", false);
        child = appconf.getChild("load", false);
        if (child != null) {
            this.loadResource = child.getAttribute("uri");
            this.loadResourceParameters = SourceParameters.create((Configuration)child);
        }
        if ((child = appconf.getChild("save", false)) != null) {
            this.saveResource = child.getAttribute("uri");
            this.saveResourceParameters = SourceParameters.create((Configuration)child);
            this.saveOnLogout = child.getAttributeAsBoolean("saveOnLogout", false);
        }
        if ((configurations = appconf.getChildren("configuration")) != null) {
            int i = 0;
            while (i < configurations.length) {
                child = configurations[i];
                String value = child.getAttribute("name");
                if (this.getConfiguration(value) != null) {
                    throw new ConfigurationException("Configuration names must be unique for application " + this.name + ": " + value);
                }
                this.configurations.put(value, child);
                ++i;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public HandlerConfiguration getHandler() {
        return this.handler;
    }

    public String getLoadResource() {
        return this.loadResource;
    }

    public String getSaveResource() {
        return this.saveResource;
    }

    public SourceParameters getLoadResourceParameters() {
        return this.loadResourceParameters;
    }

    public SourceParameters getSaveResourceParameters() {
        return this.saveResourceParameters;
    }

    public boolean saveOnLogout() {
        return this.saveOnLogout;
    }

    public boolean getLoadOnDemand() {
        return this.loadOnDemand;
    }

    public Configuration getConfiguration(String name) {
        return (Configuration)this.configurations.get(name);
    }
}

