/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.transformation;

import java.util.LinkedList;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class EffectPipe
extends AbstractXMLPipe {
    protected static final int EVENT_SET_DOCUMENT_LOCATOR = 0;
    protected static final int EVENT_START_DOCUMENT = 1;
    protected static final int EVENT_END_DOCUMENT = 2;
    protected static final int EVENT_START_PREFIX_MAPPING = 3;
    protected static final int EVENT_END_PREFIX_MAPPING = 4;
    protected static final int EVENT_START_ELEMENT = 5;
    protected static final int EVENT_END_ELEMENT = 6;
    protected static final int EVENT_ELEMENT = 7;
    protected static final int EVENT_CHARACTERS = 8;
    protected static final int EVENT_IGNORABLE_WHITESPACE = 9;
    protected static final int EVENT_PROCESSING_INSTRUCTION = 10;
    protected static final int EVENT_SKIPPED_ENTITY = 11;
    protected static final int EVENT_START_DTD = 12;
    protected static final int EVENT_END_DTD = 13;
    protected static final int EVENT_START_ENTITY = 14;
    protected static final int EVENT_END_ENTITY = 15;
    protected static final int EVENT_START_CDATA = 16;
    protected static final int EVENT_END_CDATA = 17;
    protected static final int EVENT_COMMENT = 18;
    protected int event = 0;
    protected Handler nullHandler = new NullHandler();
    protected Handler bufferHandler = new BufferHandler();
    protected LinkedList handlers = null;
    protected Handler handler = null;
    protected LinkedList elements = null;
    protected Element input = null;
    protected Locator locator = null;
    protected String name = null;
    protected String publicId = null;
    protected String systemId = null;
    protected String target = null;
    protected String data = null;
    protected String prefix = null;
    protected String uri = null;
    protected char[] c = null;
    protected int start = 0;
    protected int len = 0;
    public Output out = null;

    public void init() {
        this.handlers = new LinkedList();
        this.elements = new LinkedList();
        this.out = new Output();
    }

    public void setConsumer(XMLConsumer consumer) {
        super.setConsumer(consumer);
        this.out.setConsumer(consumer);
    }

    public void setContentHandler(ContentHandler handler) {
        super.setContentHandler(handler);
        this.out.setContentHandler(handler);
    }

    public void setLexicalHandler(LexicalHandler handler) {
        super.setLexicalHandler(handler);
        this.out.setLexicalHandler(handler);
    }

    public void recycle() {
        super.recycle();
        this.handlers = null;
        this.elements = null;
        this.out = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        try {
            this.event = 0;
            this.handler = this.handler.process();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startDocument() throws SAXException {
        this.event = 1;
        this.handler = this.handler.process();
    }

    public void endDocument() throws SAXException {
        this.event = 2;
        this.handler = this.handler.process();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.input = new Element(prefix, uri);
        this.elements.addFirst(this.input);
        this.event = 3;
        this.handler = this.handler.process();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.input = (Element)this.elements.removeFirst();
        this.event = 4;
        this.handler = this.handler.process();
        this.input = null;
    }

    public void startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
        this.input = new Element(uri, loc, raw, attrs);
        this.elements.addFirst(this.input);
        this.handlers.addFirst(this.handler);
        this.event = 7;
        this.handler = this.handler.process();
        this.event = 5;
        this.handler = this.handler.process();
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.input = (Element)this.elements.removeFirst();
        this.event = 6;
        this.handler.process();
        this.handler = (Handler)this.handlers.removeFirst();
        this.input = null;
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        this.c = c;
        this.start = start;
        this.len = len;
        this.event = 8;
        this.handler = this.handler.process();
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        this.c = c;
        this.start = start;
        this.len = len;
        this.event = 9;
        this.handler = this.handler.process();
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.target = target;
        this.data = data;
        this.event = 10;
        this.handler = this.handler.process();
    }

    public void skippedEntity(String name) throws SAXException {
        this.name = name;
        this.event = 11;
        this.handler = this.handler.process();
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.name = name;
        this.publicId = publicId;
        this.systemId = systemId;
        this.event = 12;
        this.handler = this.handler.process();
    }

    public void endDTD() throws SAXException {
        this.event = 13;
        this.handler = this.handler.process();
    }

    public void startEntity(String name) throws SAXException {
        this.name = name;
        this.event = 14;
        this.handler = this.handler.process();
    }

    public void endEntity(String name) throws SAXException {
        this.name = name;
        this.event = 15;
        this.handler = this.handler.process();
    }

    public void startCDATA() throws SAXException {
        this.event = 16;
        this.handler = this.handler.process();
    }

    public void endCDATA() throws SAXException {
        this.event = 17;
        this.handler = this.handler.process();
    }

    public void comment(char[] c, int start, int len) throws SAXException {
        this.c = c;
        this.start = start;
        this.len = len;
        this.event = 18;
        this.handler = this.handler.process();
    }

    protected class Output
    extends AbstractXMLPipe {
        private LinkedList buffers = null;
        private SaxBuffer saxBuffer = null;
        private LinkedList elements = new LinkedList();
        protected Element element = null;

        public void startPrefixMapping() throws SAXException {
            super.startPrefixMapping(EffectPipe.this.input.prefix, EffectPipe.this.input.uri);
        }

        public void endPrefixMapping() throws SAXException {
            super.endPrefixMapping(EffectPipe.this.input.prefix);
        }

        public void element(String prefix, String uri, String loc, Attributes attrs) {
            this.element = new Element(uri, loc, prefix + ":" + loc, attrs);
        }

        public void element(String prefix, String uri, String loc) {
            this.element(prefix, uri, loc, null);
        }

        public void element(String loc, Attributes attrs) {
            this.element = new Element("", loc, loc, attrs);
        }

        public void element(String loc) {
            this.element(loc, null);
        }

        public void element() {
            this.element = new Element(EffectPipe.this.input.uri, EffectPipe.this.input.loc, EffectPipe.this.input.raw, EffectPipe.this.input.attrs);
        }

        public void attribute(String prefix, String uri, String name, String value) {
            this.element.addAttribute(prefix, uri, name, value);
        }

        public void attribute(String name, String value) {
            this.element.addAttribute(name, value);
        }

        public void copyAttribute(String prefix, String uri, String name) throws SAXException {
            String value = null;
            if (EffectPipe.this.input.attrs == null || (value = EffectPipe.this.input.attrs.getValue(uri, name)) == null) {
                throw new SAXException("Attribute \"" + name + "\" cannot be copied because it does not exist.");
            }
            this.attribute(prefix, uri, name, value);
        }

        public void attributes(Attributes attrs) {
            this.element.addAttributes(attrs);
        }

        public void attributes() {
            this.attributes(EffectPipe.this.input.attrs);
        }

        public void startElement() throws SAXException {
            super.startElement(this.element.uri, this.element.loc, this.element.raw, (Attributes)this.element.attrs);
            this.elements.addFirst(this.element);
            this.element = null;
        }

        public void endElement() throws SAXException {
            this.element = (Element)this.elements.removeFirst();
            super.endElement(this.element.uri, this.element.loc, this.element.raw);
            this.element = null;
        }

        public void startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
            super.startElement(uri, loc, raw, attrs);
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            super.endElement(uri, loc, raw);
        }

        public void copy() throws SAXException {
            switch (EffectPipe.this.event) {
                case 0: {
                    this.setDocumentLocator(EffectPipe.this.locator);
                    break;
                }
                case 1: {
                    this.startDocument();
                    break;
                }
                case 2: {
                    this.endDocument();
                    break;
                }
                case 3: {
                    this.startPrefixMapping();
                    break;
                }
                case 4: {
                    this.endPrefixMapping();
                    break;
                }
                case 5: {
                    this.element();
                    this.attributes();
                    this.startElement();
                    break;
                }
                case 6: {
                    this.endElement();
                    break;
                }
                case 8: {
                    this.characters(EffectPipe.this.c, EffectPipe.this.start, EffectPipe.this.len);
                    break;
                }
                case 9: {
                    this.ignorableWhitespace(EffectPipe.this.c, EffectPipe.this.start, EffectPipe.this.len);
                    break;
                }
                case 10: {
                    this.processingInstruction(EffectPipe.this.target, EffectPipe.this.data);
                    break;
                }
                case 11: {
                    this.skippedEntity(EffectPipe.this.name);
                    break;
                }
                case 12: {
                    this.startDTD(EffectPipe.this.name, EffectPipe.this.publicId, EffectPipe.this.systemId);
                    break;
                }
                case 13: {
                    this.endDTD();
                    break;
                }
                case 14: {
                    this.startEntity(EffectPipe.this.name);
                    break;
                }
                case 15: {
                    this.endEntity(EffectPipe.this.name);
                    break;
                }
                case 16: {
                    this.startCDATA();
                    break;
                }
                case 17: {
                    this.endCDATA();
                    break;
                }
                case 18: {
                    this.comment(EffectPipe.this.c, EffectPipe.this.start, EffectPipe.this.len);
                }
            }
        }

        protected void bufferInit() {
            if (this.saxBuffer != null) {
                if (this.buffers == null) {
                    this.buffers = new LinkedList();
                }
                this.buffers.addFirst(this.saxBuffer);
            }
            this.saxBuffer = new SaxBuffer();
        }

        protected void bufferFini() {
            this.saxBuffer = this.buffers != null && this.buffers.size() > 0 ? (SaxBuffer)this.buffers.removeFirst() : null;
        }

        protected SaxBuffer getBuffer() {
            return this.saxBuffer;
        }

        public void buffer() throws SAXException {
            switch (EffectPipe.this.event) {
                case 0: {
                    this.saxBuffer.setDocumentLocator(EffectPipe.this.locator);
                    break;
                }
                case 1: {
                    this.saxBuffer.startDocument();
                    break;
                }
                case 2: {
                    this.saxBuffer.endDocument();
                    break;
                }
                case 3: {
                    this.saxBuffer.startPrefixMapping(EffectPipe.this.prefix, EffectPipe.this.uri);
                    break;
                }
                case 4: {
                    this.saxBuffer.endPrefixMapping(EffectPipe.this.prefix);
                    break;
                }
                case 5: {
                    this.saxBuffer.startElement(EffectPipe.this.input.uri, EffectPipe.this.input.loc, EffectPipe.this.input.raw, (Attributes)EffectPipe.this.input.attrs);
                    break;
                }
                case 6: {
                    this.saxBuffer.endElement(EffectPipe.this.input.uri, EffectPipe.this.input.loc, EffectPipe.this.input.raw);
                    break;
                }
                case 8: {
                    this.saxBuffer.characters(EffectPipe.this.c, EffectPipe.this.start, EffectPipe.this.len);
                    break;
                }
                case 9: {
                    this.saxBuffer.ignorableWhitespace(EffectPipe.this.c, EffectPipe.this.start, EffectPipe.this.len);
                    break;
                }
                case 10: {
                    this.saxBuffer.processingInstruction(EffectPipe.this.target, EffectPipe.this.data);
                    break;
                }
                case 11: {
                    this.saxBuffer.skippedEntity(EffectPipe.this.name);
                    break;
                }
                case 12: {
                    this.saxBuffer.startDTD(EffectPipe.this.name, EffectPipe.this.publicId, EffectPipe.this.systemId);
                    break;
                }
                case 13: {
                    this.saxBuffer.endDTD();
                    break;
                }
                case 14: {
                    this.saxBuffer.startEntity(EffectPipe.this.name);
                    break;
                }
                case 15: {
                    this.saxBuffer.endEntity(EffectPipe.this.name);
                    break;
                }
                case 16: {
                    this.saxBuffer.startCDATA();
                    break;
                }
                case 17: {
                    this.saxBuffer.endCDATA();
                    break;
                }
                case 18: {
                    this.saxBuffer.comment(EffectPipe.this.c, EffectPipe.this.start, EffectPipe.this.len);
                }
            }
        }
    }

    protected class BufferHandler
    extends Handler {
        protected BufferHandler() {
        }

        public Handler process() throws SAXException {
            switch (EffectPipe.this.event) {
                case 7: {
                    return this;
                }
            }
            EffectPipe.this.out.buffer();
            return this;
        }
    }

    protected class NullHandler
    extends Handler {
        protected NullHandler() {
        }

        public Handler process() throws SAXException {
            return this;
        }
    }

    protected abstract class Handler {
        protected Handler() {
        }

        public abstract Handler process() throws SAXException;
    }

    protected class Element {
        public final String prefix;
        public final String uri;
        public final String loc;
        public final String raw;
        public final AttributesImpl attrs;

        public Element() {
            this(null, null, null, null, null);
        }

        public Element(String prefix, String uri) {
            this(prefix, uri, null, null, null);
        }

        public Element(String uri, String loc, String raw, Attributes attrs) {
            this(null, uri, loc, raw, attrs);
        }

        public Element(String prefix, String uri, String loc, String raw, Attributes attrs) {
            this.prefix = prefix;
            this.uri = uri;
            this.loc = loc;
            this.raw = raw;
            this.attrs = attrs == null ? (loc == null && raw == null ? null : new AttributesImpl()) : new AttributesImpl(attrs);
        }

        public void addAttributes(Attributes newAttrs) {
            if (newAttrs == null || newAttrs.getLength() == 0) {
                return;
            }
            int newAttrsCount = newAttrs.getLength();
            int i = 0;
            while (i < newAttrsCount) {
                String uri = newAttrs.getURI(i);
                String loc = newAttrs.getLocalName(i);
                String raw = newAttrs.getQName(i);
                String type = newAttrs.getType(i);
                String value = newAttrs.getValue(i);
                this.addAttribute(uri, loc, raw, type, value);
                ++i;
            }
        }

        public void addAttribute(String uri, String loc, String raw, String type, String value) {
            int foundAttr = this.attrs.getIndex(uri, loc);
            if (foundAttr == -1) {
                this.attrs.addAttribute(uri, loc, raw, type, value);
            } else {
                this.attrs.setAttribute(foundAttr, uri, loc, raw, type, value);
            }
        }

        public void addAttribute(String prefix, String uri, String loc, String value) {
            this.addAttribute(uri, loc, prefix + ":" + loc, "CDATA", value);
        }

        public void addAttribute(String loc, String value) {
            this.addAttribute("", loc, loc, "CDATA", value);
        }

        public void removeAttribute(String raw) {
            int foundAttr = this.attrs.getIndex(raw);
            if (foundAttr == -1) {
                this.attrs.removeAttribute(foundAttr);
            }
        }
    }
}

