/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.generation;

import java.util.Iterator;
import java.util.List;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SaxBuffer
implements ContentHandler,
LexicalHandler,
XMLizable {
    private List buffer;

    public SaxBuffer(List list) {
        this.buffer = list;
    }

    public void skippedEntity(String name) throws SAXException {
        this.buffer.add(new SkippedEntity(name));
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.buffer.add(new IgnorableWhitespace(ch, start, length));
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.buffer.add(new PI(target, data));
    }

    public void startDocument() throws SAXException {
        this.buffer.add(StartDocument.SINGLETON);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.buffer.add(new StartElement(namespaceURI, localName, qName, atts));
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.buffer.add(new EndPrefixMapping(prefix));
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.add(new Characters(ch, start, length));
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.buffer.add(new EndElement(namespaceURI, localName, qName));
    }

    public void endDocument() throws SAXException {
        this.buffer.add(EndDocument.SINGLETON);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.buffer.add(new StartPrefixMapping(prefix, uri));
    }

    public void endCDATA() throws SAXException {
        this.buffer.add(EndCDATA.SINGLETON);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.buffer.add(new Comment(ch, start, length));
    }

    public void startEntity(String name) throws SAXException {
        this.buffer.add(new StartEntity(name));
    }

    public void endDTD() throws SAXException {
        this.buffer.add(EndDTD.SINGLETON);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.buffer.add(new StartDTD(name, publicId, systemId));
    }

    public void startCDATA() throws SAXException {
        this.buffer.add(StartCDATA.SINGLETON);
    }

    public void endEntity(String name) throws SAXException {
        this.buffer.add(new EndEntity(name));
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        Iterator i = this.buffer.iterator();
        while (i.hasNext()) {
            SaxEvent saxEvent = (SaxEvent)i.next();
            saxEvent.send(contentHandler);
        }
    }

    public static final class IgnorableWhitespace
    implements SaxEvent {
        private final char[] ch;

        public IgnorableWhitespace(char[] ch, int start, int length) {
            this.ch = new char[length];
            System.arraycopy(ch, start, this.ch, 0, length);
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.ignorableWhitespace(this.ch, 0, this.ch.length);
        }
    }

    public static final class EndCDATA
    implements SaxEvent {
        public static final EndCDATA SINGLETON = new EndCDATA();

        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).endCDATA();
            }
        }
    }

    public static final class StartCDATA
    implements SaxEvent {
        public static final StartCDATA SINGLETON = new StartCDATA();

        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).startCDATA();
            }
        }
    }

    public static final class Comment
    implements SaxEvent {
        private final char[] ch;

        public Comment(char[] ch, int start, int length) {
            this.ch = new char[length];
            System.arraycopy(ch, start, this.ch, 0, length);
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).comment(this.ch, 0, this.ch.length);
            }
        }
    }

    public static final class Characters
    implements SaxEvent {
        private final char[] ch;

        public Characters(char[] ch, int start, int length) {
            this.ch = new char[length];
            System.arraycopy(ch, start, this.ch, 0, length);
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.characters(this.ch, 0, this.ch.length);
        }

        public void toString(StringBuffer value) {
            value.append(this.ch);
        }
    }

    public static final class EndElement
    implements SaxEvent {
        private final String namespaceURI;
        private final String localName;
        private final String qName;

        public EndElement(String namespaceURI, String localName, String qName) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.qName = qName;
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.endElement(this.namespaceURI, this.localName, this.qName);
        }
    }

    public static final class StartElement
    implements SaxEvent {
        private final String namespaceURI;
        private final String localName;
        private final String qName;
        private final Attributes attrs;

        public StartElement(String namespaceURI, String localName, String qName, Attributes attrs) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.qName = qName;
            this.attrs = new AttributesImpl(attrs);
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.startElement(this.namespaceURI, this.localName, this.qName, this.attrs);
        }
    }

    public static final class EndPrefixMapping
    implements SaxEvent {
        private final String prefix;

        public EndPrefixMapping(String prefix) {
            this.prefix = prefix;
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.endPrefixMapping(this.prefix);
        }
    }

    public static final class StartPrefixMapping
    implements SaxEvent {
        private final String prefix;
        private final String uri;

        public StartPrefixMapping(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.startPrefixMapping(this.prefix, this.uri);
        }
    }

    public static final class SkippedEntity
    implements SaxEvent {
        private final String name;

        public SkippedEntity(String name) {
            this.name = name;
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.skippedEntity(this.name);
        }
    }

    public static final class EndEntity
    implements SaxEvent {
        private final String name;

        public EndEntity(String name) {
            this.name = name;
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).endEntity(this.name);
            }
        }
    }

    public static final class StartEntity
    implements SaxEvent {
        private final String name;

        public StartEntity(String name) {
            this.name = name;
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).startEntity(this.name);
            }
        }
    }

    public static final class EndDTD
    implements SaxEvent {
        public static final EndDTD SINGLETON = new EndDTD();

        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).endDTD();
            }
        }
    }

    public static final class StartDTD
    implements SaxEvent {
        private final String name;
        private final String publicId;
        private final String systemId;

        public StartDTD(String name, String publicId, String systemId) {
            this.name = name;
            this.publicId = publicId;
            this.systemId = systemId;
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            if (contentHandler instanceof LexicalHandler) {
                ((LexicalHandler)((Object)contentHandler)).startDTD(this.name, this.publicId, this.systemId);
            }
        }
    }

    public static final class PI
    implements SaxEvent {
        private final String target;
        private final String data;

        public PI(String target, String data) {
            this.target = target;
            this.data = data;
        }

        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.processingInstruction(this.target, this.data);
        }
    }

    public static final class EndDocument
    implements SaxEvent {
        public static final EndDocument SINGLETON = new EndDocument();

        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.endDocument();
        }
    }

    public static final class StartDocument
    implements SaxEvent {
        public static final StartDocument SINGLETON = new StartDocument();

        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.startDocument();
        }
    }

    public static interface SaxEvent {
        public void send(ContentHandler var1) throws SAXException;
    }
}

