/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.HashMap;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.jxpath.JXPathContext;

public class ComposedJXPathBindingBase
extends JXPathBindingBase {
    private final JXPathBindingBase[] subBindings;

    protected ComposedJXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes commonAtts, JXPathBindingBase[] childBindings) {
        super(commonAtts);
        this.subBindings = childBindings;
        if (this.subBindings != null) {
            int i = 0;
            while (i < this.subBindings.length) {
                this.subBindings[i].setParent(this);
                ++i;
            }
        }
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        if (this.subBindings != null) {
            int i = 0;
            while (i < this.subBindings.length) {
                this.subBindings[i].enableLogging(logger);
                ++i;
            }
        }
    }

    public Binding getClass(String id) {
        if (this.classes == null) {
            this.classes = new HashMap();
            if (this.subBindings != null) {
                int i = 0;
                while (i < this.subBindings.length) {
                    JXPathBindingBase binding = this.subBindings[i];
                    String bindingId = binding.getId();
                    if (bindingId != null) {
                        this.classes.put(bindingId, binding);
                    }
                    ++i;
                }
            }
        }
        return super.getClass(id);
    }

    public JXPathBindingBase[] getChildBindings() {
        return this.subBindings;
    }

    public void doLoad(Widget frmModel, JXPathContext jxpc) throws BindingException {
        if (this.subBindings != null) {
            int size = this.subBindings.length;
            int i = 0;
            while (i < size) {
                this.subBindings[i].loadFormFromModel(frmModel, jxpc);
                ++i;
            }
        }
    }

    public void doSave(Widget frmModel, JXPathContext jxpc) throws BindingException {
        if (this.subBindings != null) {
            int size = this.subBindings.length;
            int i = 0;
            while (i < size) {
                this.subBindings[i].saveFormToModel(frmModel, jxpc);
                ++i;
            }
        }
    }
}

