/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager;

import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.instrument.manager.InstrumentProxy;
import org.apache.excalibur.instrument.manager.InstrumentSample;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptorLocal;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptorLocalImpl;
import org.apache.excalibur.instrument.manager.InstrumentSampleListener;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleSnapshot;
import org.apache.excalibur.instrument.manager.interfaces.InstrumentSampleUtils;

abstract class AbstractInstrumentSample
extends AbstractLogEnabled
implements InstrumentSample {
    private InstrumentProxy m_instrumentProxy;
    private boolean m_configured;
    private String m_name;
    private long m_interval;
    private int m_size;
    private String m_description;
    private InstrumentSampleDescriptorLocal m_descriptor;
    private long m_maxAge;
    protected long m_time;
    private long m_leaseExpirationTime;
    private boolean m_expired;
    private int m_historyIndex;
    private int[] m_historyOld;
    private int[] m_historyNew;
    private InstrumentSampleListener[] m_listeners;
    private int m_stateVersion;

    protected AbstractInstrumentSample(InstrumentProxy instrumentProxy, String name, long interval, int size, String description, long lease) {
        this.m_instrumentProxy = instrumentProxy;
        if (interval < 1L) {
            throw new IllegalArgumentException("interval must be at least 1.");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size must be at least 1.");
        }
        this.m_name = name;
        this.m_interval = interval;
        this.m_size = size;
        this.m_description = description;
        this.m_leaseExpirationTime = lease > 0L ? System.currentTimeMillis() + lease : 0L;
        this.m_maxAge = (long)this.m_size * this.m_interval;
        this.init();
        this.m_descriptor = new InstrumentSampleDescriptorLocalImpl(this);
    }

    public InstrumentProxy getInstrumentProxy() {
        return this.m_instrumentProxy;
    }

    public boolean isConfigured() {
        return this.m_configured;
    }

    public final String getName() {
        return this.m_name;
    }

    public final long getInterval() {
        return this.m_interval;
    }

    public final int getSize() {
        return this.m_size;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public InstrumentSampleDescriptorLocal getDescriptor() {
        return this.m_descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getValue() {
        long time;
        int value;
        boolean update;
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            long now = System.currentTimeMillis();
            update = this.update(now);
            value = this.getValueInner();
            time = this.m_time;
        }
        if (update) {
            this.updateListeners(value, time);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTime() {
        long time;
        int value;
        boolean update;
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            long now = System.currentTimeMillis();
            update = this.update(now);
            value = this.getValueInner();
            time = this.m_time;
        }
        if (update) {
            this.updateListeners(value, time);
        }
        return time;
    }

    public long getLeaseExpirationTime() {
        return this.m_leaseExpirationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long extendLease(long lease) {
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            long newLeaseExpirationTime;
            if (this.m_leaseExpirationTime > 0L && !this.m_expired && (newLeaseExpirationTime = System.currentTimeMillis() + lease) > this.m_leaseExpirationTime) {
                this.m_leaseExpirationTime = newLeaseExpirationTime;
                this.stateChanged();
            }
            return this.m_leaseExpirationTime;
        }
    }

    public void expire() {
        this.update(this.m_leaseExpirationTime);
        this.m_expired = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InstrumentSampleSnapshot getSnapshot() {
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            long time = System.currentTimeMillis();
            this.update(time);
            return new InstrumentSampleSnapshot(this.m_name, this.m_interval, this.m_size, this.m_time, this.getHistorySnapshot(), this.m_stateVersion);
        }
    }

    public int getStateVersion() {
        return this.m_stateVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstrumentSampleListener(InstrumentSampleListener listener) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("A InstrumentSampleListener was added to sample, " + this.m_name + " : " + listener.getClass().getName());
        }
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            InstrumentSampleListener[] newListeners;
            InstrumentSampleListener[] oldListeners = this.m_listeners;
            if (oldListeners == null) {
                newListeners = new InstrumentSampleListener[]{listener};
            } else {
                newListeners = new InstrumentSampleListener[oldListeners.length + 1];
                System.arraycopy(oldListeners, 0, newListeners, 0, oldListeners.length);
                newListeners[oldListeners.length] = listener;
            }
            this.m_listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstrumentSampleListener(InstrumentSampleListener listener) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("A InstrumentSampleListener was removed from sample, " + this.m_name + " : " + listener.getClass().getName());
        }
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            InstrumentSampleListener[] newListeners;
            InstrumentSampleListener[] oldListeners = this.m_listeners;
            if (oldListeners == null) {
                newListeners = null;
            } else if (oldListeners.length == 1) {
                newListeners = oldListeners[0] == listener ? null : oldListeners;
            } else {
                int pos = -1;
                int i = 0;
                while (i < oldListeners.length) {
                    if (oldListeners[i] == listener) {
                        pos = i;
                        break;
                    }
                    ++i;
                }
                if (pos < 0) {
                    newListeners = oldListeners;
                } else {
                    newListeners = new InstrumentSampleListener[oldListeners.length - 1];
                    if (pos > 0) {
                        System.arraycopy(oldListeners, 0, newListeners, 0, pos);
                    }
                    if (pos < oldListeners.length - 1) {
                        System.arraycopy(oldListeners, pos + 1, newListeners, pos, oldListeners.length - 1 - pos);
                    }
                }
            }
            this.m_listeners = newListeners;
        }
    }

    protected void updateListeners(int value, long time) {
        InstrumentSampleListener[] listeners = this.m_listeners;
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].setValue(this.getName(), value, time);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Configuration saveState() {
        if (!this.isConfigured() && this.getLeaseExpirationTime() <= 0L) {
            return null;
        }
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            DefaultConfiguration state = new DefaultConfiguration("sample", "-");
            state.setAttribute("type", InstrumentSampleUtils.getInstrumentSampleTypeName((int)this.getType()));
            state.setAttribute("interval", Long.toString(this.m_interval));
            state.setAttribute("size", Integer.toString(this.m_size));
            state.setAttribute("time", Long.toString(this.m_time));
            if (this.getLeaseExpirationTime() > 0L) {
                state.setAttribute("lease-expiration", Long.toString(this.getLeaseExpirationTime()));
                state.setAttribute("description", this.m_description);
            }
            DefaultConfiguration samples = new DefaultConfiguration("history", "-");
            int[] history = this.getHistorySnapshot();
            StringBuffer sb = new StringBuffer();
            sb.append(history[history.length - 1]);
            int i = history.length - 2;
            while (i >= 0) {
                sb.append(',');
                sb.append(history[i]);
                --i;
            }
            samples.setValue(sb.toString());
            state.addChild((Configuration)samples);
            this.saveState(state);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadState(Configuration state) throws ConfigurationException {
        AbstractInstrumentSample abstractInstrumentSample = this;
        synchronized (abstractInstrumentSample) {
            int value;
            long savedTime = this.m_time = state.getAttributeAsLong("time");
            this.m_leaseExpirationTime = state.getAttributeAsLong("lease-expiration", 0L);
            this.m_historyIndex = 0;
            Configuration history = state.getChild("history");
            String compactSamples = history.getValue();
            StringTokenizer st = new StringTokenizer(compactSamples, ",");
            int[] sampleValues = new int[st.countTokens()];
            int i = 0;
            while (i < sampleValues.length) {
                try {
                    sampleValues[i] = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationException("The compact sample data could not be loaded, because of a number format problem, for InstrumentSample: " + this.m_name);
                }
                ++i;
            }
            if (sampleValues.length > 0) {
                value = sampleValues[0];
                int i2 = 0;
                while (i2 < this.m_size - 1) {
                    this.m_historyOld[this.m_size - 2 - i2] = i2 < sampleValues.length - 1 ? sampleValues[i2 + 1] : 0;
                    ++i2;
                }
            } else {
                value = 0;
            }
            this.loadState(value, state);
            if (this.calculateSampleTime(System.currentTimeMillis()) > savedTime) {
                this.postSaveNeedsReset();
            }
            if (this.m_leaseExpirationTime > 0L) {
                this.getInstrumentProxy().getInstrumentableProxy().getInstrumentManager().registerLeasedInstrumentSample(this);
            }
        }
        this.stateChanged();
    }

    void setConfigured() {
        this.m_configured = true;
    }

    private void init() {
        this.m_time = this.calculateSampleTime(System.currentTimeMillis());
        this.m_historyIndex = 0;
        this.m_historyOld = new int[this.m_size - 1];
        this.m_historyNew = new int[this.m_size - 1];
    }

    protected void saveState(DefaultConfiguration state) {
    }

    protected abstract void loadState(int var1, Configuration var2) throws ConfigurationException;

    protected abstract void postSaveNeedsReset();

    private long calculateSampleTime(long time) {
        return time / this.m_interval * this.m_interval;
    }

    protected abstract int getValueInner();

    protected abstract void advanceToNextSample();

    /*
     * Unable to fully structure code
     */
    protected boolean update(long time) {
        block2: {
            block3: {
                if (this.m_expired) {
                    return false;
                }
                if (time - this.m_time < this.m_interval) break block2;
                if (time - this.m_time < this.m_maxAge) ** GOTO lbl17
                this.advanceToNextSample();
                this.init();
                break block3;
lbl-1000:
                // 1 sources

                {
                    this.m_historyNew[this.m_historyIndex] = this.getValueInner();
                    this.m_time += this.m_interval;
                    this.advanceToNextSample();
                    ++this.m_historyIndex;
                    if (this.m_historyIndex < this.m_size - 1) continue;
                    tmp = this.m_historyOld;
                    this.m_historyOld = this.m_historyNew;
                    this.m_historyNew = tmp;
                    this.m_historyIndex = 0;
lbl17:
                    // 3 sources

                    ** while (time - this.m_time >= this.m_interval)
                }
            }
            return true;
        }
        return false;
    }

    private int[] getHistorySnapshot() {
        int[] history = new int[this.m_size];
        int sizem1 = this.m_size - 1;
        if (this.m_size > 1) {
            if (this.m_historyIndex < sizem1) {
                System.arraycopy(this.m_historyOld, this.m_historyIndex, history, 0, sizem1 - this.m_historyIndex);
            }
            if (this.m_historyIndex > 0) {
                System.arraycopy(this.m_historyNew, 0, history, sizem1 - this.m_historyIndex, this.m_historyIndex);
            }
        }
        history[this.m_size - 1] = this.getValueInner();
        return history;
    }

    protected void stateChanged() {
        ++this.m_stateVersion;
        this.m_instrumentProxy.stateChanged();
    }

    public String toString() {
        return "InstrumentSample[name=" + this.m_name + ", type=" + InstrumentSampleUtils.getInstrumentSampleTypeName((int)this.getType()) + ", interval=" + this.m_interval + ", size=" + this.m_size + ", lease=" + this.m_leaseExpirationTime + "]";
    }
}

