/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractDatabaseAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.BooleanUtils;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class DbXMLAuthenticatorAction
extends AbstractDatabaseAction
implements ThreadSafe {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws Exception {
        ResourceSet rs = null;
        boolean reloadable = true;
        if (this.settings.containsKey((Object)"reloadable")) {
            reloadable = Boolean.valueOf((String)this.settings.get((Object)"reloadable"));
        }
        try {
            Request req;
            Configuration conf = this.getConfiguration(parameters.getParameter("descriptor", (String)this.settings.get((Object)"descriptor")), resolver, parameters.getParameterAsBoolean("reloadable", reloadable));
            boolean cs = true;
            String create_session = parameters.getParameter("create-session", (String)this.settings.get((Object)"create-session"));
            if (create_session != null && ("no".equals(create_session.trim()) || "false".equals(create_session.trim()))) {
                cs = false;
            }
            if ((req = ObjectModelHelper.getRequest((Map)objectModel)) == null) {
                this.getLogger().debug("DBXMLAUTH: no request object");
                return null;
            }
            rs = this.Authenticate(conf, req);
            if (rs != null) {
                this.getLogger().debug("DBXMLAUTH: authorized successfully");
                Session session = null;
                if (cs) {
                    session = req.getSession(false);
                    if (session != null) {
                        session.invalidate();
                    }
                    if ((session = req.getSession(true)) == null) {
                        return null;
                    }
                    this.getLogger().debug("DBXMLAUTH: session created");
                } else {
                    this.getLogger().debug("DBXMLAUTH: leaving session untouched");
                }
                HashMap actionMap = this.propagateParameters(conf, rs, session);
                return Collections.unmodifiableMap(actionMap);
            }
            req.setAttribute("message", (Object)"The username or password were incorrect, please check your CAPS LOCK key and try again.");
            this.getLogger().debug("DBXMLAUTH: no results for query");
        }
        catch (Exception e) {
            this.getLogger().debug("exception: ", (Throwable)e);
            return null;
        }
        return null;
    }

    private String getAuthQuery(Configuration conf, Request req) {
        StringBuffer queryBuffer = new StringBuffer("//");
        StringBuffer queryBufferEnd = new StringBuffer("");
        boolean nullable = false;
        Configuration table = conf.getChild("root");
        Configuration[] select = table.getChildren("select");
        try {
            queryBuffer.append(table.getAttribute("name"));
            int i = 0;
            while (i < select.length) {
                block14: {
                    String request_param;
                    String dbcol = "[" + select[i].getAttribute("element");
                    try {
                        request_param = select[i].getAttribute("request-param");
                        if (request_param == null) break block14;
                        if (request_param.trim().equals("")) {
                        }
                    }
                    catch (Exception e) {}
                    break block14;
                    try {
                        String nullstr = select[i].getAttribute("nullable");
                        if (nullstr != null) {
                            nullstr = nullstr.trim();
                        }
                        if (BooleanUtils.toBoolean((String)nullstr)) {
                            nullable = true;
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    String request_value = req.getParameter(request_param);
                    if (request_value == null || request_value.trim().equals("")) {
                        if (!nullable) {
                            this.getLogger().debug("DBXMLAUTH: request-param " + request_param + " does not exist");
                            return null;
                        }
                    } else {
                        queryBufferEnd.append(dbcol).append("='").append(request_value).append("']");
                    }
                }
                ++i;
            }
            if (!queryBufferEnd.toString().trim().equals("")) {
                queryBuffer.append(queryBufferEnd);
            }
            return queryBuffer.toString();
        }
        catch (Exception e) {
            this.getLogger().debug("DBXMLAUTH: got exception: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceSet Authenticate(Configuration conf, Request req) throws Exception, XMLDBException {
        ResourceSet rs = null;
        String query = this.getAuthQuery(conf, req);
        if (query == null) {
            this.getLogger().debug("DBXMLAUTH: have not got query");
            req.setAttribute("message", (Object)"The authenticator is misconfigured");
            return null;
        }
        this.getLogger().debug("DBXMLAUTH: query is: " + query);
        Collection col = this.CreateConnection(conf);
        if (col != null) {
            if (col.isOpen()) {
                try {
                    XPathQueryService service = (XPathQueryService)col.getService("XPathQueryService", "1.0");
                    rs = service.query(query);
                    ResourceIterator results = rs.getIterator();
                    if (!results.hasMoreResources()) {
                        this.getLogger().debug("DBXMLAUTH: auth failed");
                        ResourceSet resourceSet = null;
                        return resourceSet;
                    }
                    this.getLogger().debug("DBXMLAUTH: auth OK");
                    ResourceSet resourceSet = rs;
                    return resourceSet;
                }
                catch (XMLDBException e) {
                    this.getLogger().debug("DBXMLAUTH: got exception: " + (Object)((Object)e));
                    ResourceSet resourceSet = null;
                    return resourceSet;
                }
                finally {
                    if (col != null) {
                        try {
                            col.close();
                        }
                        catch (Exception e) {}
                    }
                    this.getLogger().debug("DBXMLAUTH: collection closed");
                }
            }
            this.getLogger().debug("DBXMLAUTH: error: collection closed !!");
        } else {
            this.getLogger().debug("DBXMLAUTH: couldn't open a connection with DB");
        }
        return null;
    }

    private Collection CreateConnection(Configuration conf) throws Exception, XMLDBException {
        Collection col = null;
        Configuration conn = conf.getChild("connection");
        try {
            Class<?> c = Class.forName(conn.getChild("driver").getValue());
            Database database = (Database)c.newInstance();
            DatabaseManager.registerDatabase((Database)database);
            col = DatabaseManager.getCollection((String)conn.getChild("base").getValue());
        }
        catch (XMLDBException e) {
            this.getLogger().debug("DBXMLAUTH: Exception occured " + e.errorCode);
        }
        return col;
    }

    private HashMap propagateParameters(Configuration conf, ResourceSet resultSet, Session session) {
        XObject xo;
        Configuration table = conf.getChild("root");
        Configuration[] select = table.getChildren("select");
        HashMap<String, String> map = new HashMap<String, String>();
        Node originalnode = null;
        try {
            ResourceIterator results = resultSet.getIterator();
            xo = new XObject();
            XMLResource resource = (XMLResource)results.nextResource();
            originalnode = resource.getContentAsDOM();
        }
        catch (Exception e) {
            this.getLogger().debug("DBXMLAUTH: error creating XObject ");
        }
        try {
            int i = 0;
            while (i < select.length) {
                block18: {
                    try {
                        String type;
                        String session_param = select[i].getAttribute("to-session");
                        if (session_param == null || session_param.trim().equals("")) break block18;
                        String s = "";
                        try {
                            xo = XPathAPI.eval((Node)originalnode, (String)("/" + table.getAttribute("name") + "/" + select[i].getAttribute("element")));
                            s = xo.toString();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            type = select[i].getAttribute("type");
                        }
                        catch (Exception e) {
                            type = null;
                        }
                        if (type == null || "".equals(type.trim())) {
                            type = "string";
                        }
                        Object o = null;
                        if ("string".equals(type)) {
                            o = s;
                        } else if ("long".equals(type)) {
                            Long l = Long.decode(s);
                            o = l;
                        } else if ("double".equals(type)) {
                            Double d = Double.valueOf(s);
                            o = d;
                        }
                        if (session != null) {
                            session.setAttribute(session_param, o);
                            this.getLogger().debug("DBXMLAUTH: propagating param " + session_param + "=" + s);
                        }
                        map.put(session_param, (String)o);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
            return map;
        }
        catch (Exception e) {
            this.getLogger().debug("exception: ", (Throwable)e);
            return null;
        }
    }
}

