/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql.jdbc2.optional;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.gjt.mm.mysql.jdbc2.optional.MysqlPooledConnection;

public class LogicalHandle
implements Connection {
    private boolean closed;
    private MysqlPooledConnection mpc = null;
    private Connection mc = null;
    private String invalidHandleStr = "Logical handle no longer valid";

    public LogicalHandle(MysqlPooledConnection mysqlPooledConnection, Connection connection) throws SQLException {
        this.mpc = mysqlPooledConnection;
        this.mc = connection;
        this.closed = false;
    }

    public void clearWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.mpc.callListener(1, null);
        this.closed = true;
    }

    public void commit() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.commit();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.createStatement();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getCatalog();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getMetaData();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.getWarnings();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            return this.mc.prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public void rollback() throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.rollback();
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public void setCatalog(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.closed) {
            throw new SQLException(this.invalidHandleStr);
        }
        try {
            this.mc.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.mpc.callListener(2, sQLException);
            throw sQLException;
        }
    }
}

