/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.util.Stack;
import org.apache.cocoon.components.language.markup.CocoonMarkupLanguage;
import org.apache.cocoon.components.language.programming.ProgrammingLanguage;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XSPMarkupLanguage
extends CocoonMarkupLanguage {
    public String getRootElement() {
        return "page";
    }

    protected AbstractXMLPipe getPreprocessFilter(String filename, AbstractXMLPipe filter, ProgrammingLanguage language) {
        PreProcessFilter prefilter = new PreProcessFilter(filter, filename, language);
        prefilter.enableLogging(this.getLogger());
        return prefilter;
    }

    protected class PreProcessFilter
    extends CocoonMarkupLanguage.PreProcessFilter {
        private Stack stack;

        public PreProcessFilter(AbstractXMLPipe filter, String filename, ProgrammingLanguage language) {
            super(filter, filename, language);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.stack = new Stack();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.stack.push(new String[]{namespaceURI, localName, qName});
            super.startElement(namespaceURI, localName, qName, atts);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.stack.pop();
            super.endElement(namespaceURI, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String[] tag = (String[])this.stack.peek();
            String tagURI = tag[0];
            String tagLName = tag[1];
            boolean flag = XSPMarkupLanguage.this.getURI().equals(tagURI);
            if (flag && tagLName.equals("page")) {
                super.characters(ch, start, length);
            } else if (flag && (tagLName.equals("expr") || tagLName.equals("logic") || tagLName.equals("structure") || tagLName.equals("include"))) {
                super.characters(ch, start, length);
            } else {
                String value = String.valueOf(ch, start, length);
                super.startElement(XSPMarkupLanguage.this.getURI(), "text", this.localPrefix + ":text", new AttributesImpl());
                super.characters(value.toCharArray(), 0, value.length());
                super.endElement(XSPMarkupLanguage.this.getURI(), "text", this.localPrefix + ":text");
            }
        }
    }
}

