/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractDOMTransformer
extends AbstractTransformer
implements Transformer,
DOMBuilder.Listener,
Composable,
Disposable,
Recyclable {
    protected SourceResolver resolver;
    protected Map objectModel;
    protected String source;
    protected Parameters parameters;
    protected ComponentManager manager;
    protected DOMBuilder builder = new DOMBuilder(this);

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        this.objectModel = objectModel;
        this.source = src;
        this.parameters = par;
    }

    public void recycle() {
        this.resolver = null;
        this.source = null;
        this.objectModel = null;
        this.parameters = null;
        this.builder.recycle();
    }

    public void dispose() {
        this.builder = null;
        this.manager = null;
    }

    public void notify(Document doc) throws SAXException {
        Document newdoc = this.transform(doc);
        DOMStreamer s = new DOMStreamer(this.contentHandler, this.lexicalHandler);
        s.stream(newdoc);
    }

    protected abstract Document transform(Document var1);

    public void setDocumentLocator(Locator locator) {
        this.builder.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.builder.startDocument();
    }

    public void endDocument() throws SAXException {
        this.builder.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.builder.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.builder.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.builder.startElement(uri, loc, raw, a);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.builder.endElement(uri, loc, raw);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        this.builder.characters(c, start, len);
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        this.builder.ignorableWhitespace(c, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.builder.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.builder.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.builder.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this.builder.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        this.builder.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        this.builder.endEntity(name);
    }

    public void startCDATA() throws SAXException {
        this.builder.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this.builder.endCDATA();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        this.builder.comment(ch, start, len);
    }
}

