/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.multipart;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.cocoon.servlet.multipart.Part;

public class PartOnDisk
extends Part {
    private File file = null;
    private int size;

    protected PartOnDisk(Map headers, File file) {
        super(headers);
        this.file = file;
        this.file.deleteOnExit();
        this.size = (int)file.length();
    }

    public String getFileName() {
        return this.file.getName();
    }

    public int getSize() {
        return this.size;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() throws Exception {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        throw new IllegalStateException("This part has already been disposed.");
    }

    public String toString() {
        return this.file.getPath();
    }

    public void dispose() {
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

