/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.util.ClassUtils;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.SAXException;

public abstract class AbstractEnvironment
extends AbstractLogEnabled
implements Environment {
    protected String uris;
    protected StringBuffer prefix = new StringBuffer();
    protected String view = null;
    protected String action = null;
    protected String context = null;
    private String tempInitContext = null;
    protected String rootContext = null;
    protected HashMap objectModel = null;
    protected SourceResolver sourceResolver;
    protected ComponentManager manager;
    private Map attributes = new HashMap();
    protected org.apache.cocoon.util.BufferedOutputStream secureOutputStream;
    protected OutputStream outputStream;
    protected static Method avalonToCocoonSourceWrapper;
    protected boolean initializedComponents = false;
    static /* synthetic */ Class class$org$apache$cocoon$environment$Environment;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$ComponentManager;

    public AbstractEnvironment(String uri, String view, File file) throws MalformedURLException {
        this(uri, view, file, null);
    }

    public AbstractEnvironment(String uri, String view, File file, String action) throws MalformedURLException {
        this(uri, view, file.toURL().toExternalForm(), action);
    }

    public AbstractEnvironment(String uri, String view, String context, String action) throws MalformedURLException {
        this.uris = uri;
        this.view = view;
        this.tempInitContext = context;
        this.action = action;
        this.objectModel = new HashMap();
    }

    protected void setView(String view) {
        if (this.view != null) {
            throw new IllegalStateException("View was already set on this environment");
        }
        this.view = view;
    }

    protected void setAction(String action) {
        if (this.action != null) {
            throw new IllegalStateException("Action was already set on this environment");
        }
        this.action = action;
    }

    protected static String extractView(Request request) {
        return request.getParameter("cocoon-view");
    }

    protected static String extractAction(Request req) {
        String action = req.getParameter("cocoon-action");
        if (action != null) {
            return action;
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("cocoon-action-")) continue;
            if (name.endsWith(".x") || name.endsWith(".y")) {
                return name.substring("cocoon-action-".length(), name.length() - 2);
            }
            return name.substring("cocoon-action-".length());
        }
        return null;
    }

    public String getURI() {
        return this.uris;
    }

    public String getRootContext() {
        if (!this.initializedComponents) {
            this.initComponents();
        }
        return this.rootContext;
    }

    public String getContext() {
        if (!this.initializedComponents) {
            this.initComponents();
        }
        return this.context;
    }

    public String getURIPrefix() {
        return this.prefix.toString();
    }

    protected void setURIPrefix(String prefix) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Set the URI Prefix (OLD=" + this.getURIPrefix() + ", NEW=" + prefix + ")");
        }
        this.prefix = new StringBuffer(prefix);
    }

    protected void setContext(String context) {
        this.context = context;
    }

    public void setContext(String prefix, String uri, String context) {
        this.setContext(context);
        this.setURIPrefix(prefix == null ? "" : prefix);
        this.uris = uri;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Reset context to " + this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeContext(String prefix, String newContext) throws IOException {
        block13: {
            int l;
            if (!this.initializedComponents) {
                this.initComponents();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Changing Cocoon context");
                this.getLogger().debug("  from context(" + this.context + ") and prefix(" + this.prefix + ")");
                this.getLogger().debug("  to context(" + newContext + ") and prefix(" + prefix + ")");
                this.getLogger().debug("  at URI " + this.uris);
            }
            if ((l = prefix.length()) >= 1) {
                if (!this.uris.startsWith(prefix)) {
                    String message = "The current URI (" + this.uris + ") doesn't start with given prefix (" + prefix + ")";
                    this.getLogger().error(message);
                    throw new RuntimeException(message);
                }
                this.prefix.append(prefix);
                this.uris = this.uris.substring(l);
                if (this.uris.startsWith("/")) {
                    this.uris = this.uris.substring(1);
                    this.prefix.append('/');
                }
            }
            if (SourceUtil.getScheme(this.context).equals("zip")) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Base context is zip: " + this.context);
                }
                org.apache.excalibur.source.Source source = null;
                try {
                    source = this.sourceResolver.resolveURI(this.context + newContext);
                    this.context = source.getURI();
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.sourceResolver.release(source);
                    throw throwable;
                }
                this.sourceResolver.release(source);
                {
                    break block13;
                }
            }
            String sContext = newContext.charAt(0) == '/' ? "file:" + newContext : (newContext.indexOf(58) > 1 ? newContext : this.context + '/' + newContext);
            int i = sContext.lastIndexOf(47);
            if (i != -1 && i + 1 < sContext.length()) {
                sContext = sContext.substring(0, i + 1);
            }
            org.apache.excalibur.source.Source source = null;
            try {
                source = this.sourceResolver.resolveURI(sContext);
                this.context = source.getURI();
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                this.sourceResolver.release(source);
                throw throwable;
            }
            this.sourceResolver.release(source);
            {
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("New context is " + this.context);
        }
    }

    public abstract void redirect(boolean var1, String var2) throws IOException;

    public void globalRedirect(boolean sessionmode, String newURL) throws IOException {
        this.redirect(sessionmode, newURL);
    }

    public String getView() {
        return this.view;
    }

    public String getAction() {
        return this.action;
    }

    public void setStatus(int statusCode) {
    }

    public Map getObjectModel() {
        return this.objectModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source resolve(String systemId) throws ProcessingException, SAXException, IOException {
        Class clazz;
        if (!this.initializedComponents) {
            this.initComponents();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolving '" + systemId + "' in context '" + this.context + "'");
        }
        if (systemId == null) {
            throw new SAXException("Invalid System ID");
        }
        try {
            clazz = ClassUtils.loadClass("org.apache.cocoon.components.source.impl.AvalonToCocoonSourceInvocationHandler");
        }
        catch (Exception e) {
            throw new ProcessingException("The deprecated resolve() method of the environment was called.Please either update your code to use the new resolveURI() method or install the deprecation support.", e);
        }
        if (null == avalonToCocoonSourceWrapper) {
            Class<?> e = this.getClass();
            synchronized (e) {
                try {
                    avalonToCocoonSourceWrapper = clazz.getDeclaredMethod("createProxy", ClassUtils.loadClass("org.apache.excalibur.source.Source"), ClassUtils.loadClass("org.apache.excalibur.source.SourceResolver"), ClassUtils.loadClass((class$org$apache$cocoon$environment$Environment == null ? (class$org$apache$cocoon$environment$Environment = AbstractEnvironment.class$("org.apache.cocoon.environment.Environment")) : class$org$apache$cocoon$environment$Environment).getName()), ClassUtils.loadClass((class$org$apache$avalon$framework$component$ComponentManager == null ? (class$org$apache$avalon$framework$component$ComponentManager = AbstractEnvironment.class$("org.apache.avalon.framework.component.ComponentManager")) : class$org$apache$avalon$framework$component$ComponentManager).getName()));
                }
                catch (Exception e2) {
                    throw new ProcessingException("The deprecated resolve() method of the environment was called.Please either update your code to use the new resolveURI() method or install the deprecation support.", e2);
                }
            }
        }
        try {
            org.apache.excalibur.source.Source source = this.resolveURI(systemId);
            Source wrappedSource = (Source)avalonToCocoonSourceWrapper.invoke((Object)clazz, source, this.sourceResolver, this, this.manager);
            return wrappedSource;
        }
        catch (SourceException se) {
            throw SourceUtil.handle(se);
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to create source wrapper.", e);
        }
    }

    public boolean isResponseModified(long lastModified) {
        return true;
    }

    public void setResponseIsNotModified() {
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(-1);
    }

    public OutputStream getOutputStream(int bufferSize) throws IOException {
        if (bufferSize == -1) {
            if (this.secureOutputStream == null) {
                this.secureOutputStream = new org.apache.cocoon.util.BufferedOutputStream(this.outputStream);
            }
            return this.secureOutputStream;
        }
        if (bufferSize == 0) {
            return this.outputStream;
        }
        this.outputStream = new BufferedOutputStream(this.outputStream, bufferSize);
        return this.outputStream;
    }

    public boolean tryResetResponse() throws IOException {
        if (this.secureOutputStream != null) {
            this.secureOutputStream.clearBuffer();
            return true;
        }
        return false;
    }

    public void commitResponse() throws IOException {
        if (this.secureOutputStream != null) {
            this.secureOutputStream.realFlush();
        } else if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public org.apache.excalibur.source.Source resolveURI(String location) throws MalformedURLException, IOException, SourceException {
        return this.resolveURI(location, null, null);
    }

    public org.apache.excalibur.source.Source resolveURI(String location, String baseURI, Map parameters) throws MalformedURLException, IOException, SourceException {
        if (!this.initializedComponents) {
            this.initComponents();
        }
        return this.sourceResolver.resolveURI(location, baseURI, parameters);
    }

    public void release(org.apache.excalibur.source.Source source) {
        if (null != source) {
            this.sourceResolver.release(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initComponents() {
        block6: {
            this.initializedComponents = true;
            try {
                this.manager = CocoonComponentManager.getSitemapComponentManager();
                this.sourceResolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                if (this.tempInitContext == null) break block6;
                org.apache.excalibur.source.Source source = null;
                try {
                    source = this.sourceResolver.resolveURI(this.tempInitContext);
                    this.context = source.getURI();
                    if (this.rootContext == null) {
                        this.rootContext = this.context;
                    }
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.sourceResolver.release(source);
                    throw throwable;
                }
                this.sourceResolver.release(source);
                this.tempInitContext = null;
            }
            catch (ComponentException ce) {
                throw new CascadingRuntimeException("Unable to lookup component.", (Throwable)ce);
            }
            catch (IOException ie) {
                throw new CascadingRuntimeException("Unable to resolve URI: " + this.tempInitContext, (Throwable)ie);
            }
        }
    }

    public void startingProcessing() {
    }

    public void finishingProcessing() {
        if (null != this.manager) {
            this.manager.release((Component)this.sourceResolver);
            this.manager = null;
            this.sourceResolver = null;
        }
        this.initializedComponents = false;
    }

    public boolean isInternalRedirect() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

