/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.variables;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.sitemap.SitemapParameters;

public abstract class VariableResolver {
    public static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    protected final String originalExpr;

    protected VariableResolver(String expr) {
        this.originalExpr = expr;
    }

    public final String toString() {
        return this.originalExpr;
    }

    public boolean equals(Object object) {
        if (object instanceof VariableResolver) {
            VariableResolver other = (VariableResolver)object;
            return this.originalExpr == null && other.originalExpr == null || this.originalExpr.equals(other.originalExpr);
        }
        return false;
    }

    public int hashCode() {
        return this.originalExpr == null ? 0 : this.originalExpr.hashCode();
    }

    public String resolve(Map objectModel) throws PatternException {
        return this.resolve(null, objectModel);
    }

    public abstract String resolve(InvokeContext var1, Map var2) throws PatternException;

    public static Parameters buildParameters(Map expressions, InvokeContext context, Map objectModel) throws PatternException {
        if (expressions == null || expressions.size() == 0) {
            return Parameters.EMPTY_PARAMETERS;
        }
        SitemapParameters result = new SitemapParameters();
        if (expressions instanceof SitemapParameters.ExtendedHashMap) {
            result.setStatementLocation(((SitemapParameters.ExtendedHashMap)expressions).getLocation());
        }
        Iterator iter = expressions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            result.setParameter(((VariableResolver)entry.getKey()).resolve(context, objectModel), ((VariableResolver)entry.getValue()).resolve(context, objectModel));
        }
        return result;
    }

    public static Map buildMap(Map expressions, InvokeContext context, Map objectModel) throws PatternException {
        SitemapParameters.ExtendedHashMap result;
        int size;
        if (expressions == null || (size = expressions.size()) == 0) {
            return EMPTY_MAP;
        }
        if (expressions instanceof SitemapParameters.ExtendedHashMap) {
            Configuration config = ((SitemapParameters.ExtendedHashMap)expressions).getConfiguration();
            result = new SitemapParameters.ExtendedHashMap(config, size);
        } else {
            result = new HashMap(size);
        }
        Iterator iter = expressions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            result.put(((VariableResolver)entry.getKey()).resolve(context, objectModel), ((VariableResolver)entry.getValue()).resolve(context, objectModel));
        }
        return result;
    }
}

