/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleParentProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ErrorHandlerHelper;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelineNode;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Redirector;

public final class PipelinesNode
extends SimpleParentProcessingNode
implements Composable,
Disposable {
    private ComponentManager manager;
    private ErrorHandlerHelper errorHandlerHelper = new ErrorHandlerHelper();
    private ProcessingNode errorHandler;

    public void compose(ComponentManager manager) {
        this.manager = manager;
        this.errorHandlerHelper.compose(manager);
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.errorHandlerHelper.enableLogging(logger);
    }

    public void setErrorHandler(ProcessingNode node) {
        this.errorHandler = node;
    }

    public void setChildren(ProcessingNode[] nodes) {
        ((PipelineNode)nodes[nodes.length - 1]).setLast(true);
        super.setChildren(nodes);
    }

    public static Redirector getRedirector(Environment env) {
        return (Redirector)env.getAttribute("sitemap:redirector");
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        super.invoke(env, context);
        context.recompose(this.manager);
        try {
            return this.invokeNodes(this.children, env, context);
        }
        catch (Exception ex) {
            if (this.errorHandler != null) {
                return this.errorHandlerHelper.invokeErrorHandler(this.errorHandler, ex, env);
            }
            throw ex;
        }
    }

    public void dispose() {
        if (this.manager instanceof Disposable) {
            ((Disposable)this.manager).dispose();
        }
        this.manager = null;
    }
}

