/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;

public class InvokeContext
implements Recomposable,
Disposable,
LogEnabled {
    private List mapStack = new ArrayList();
    private HashMap nameToMap = new HashMap();
    private HashMap mapToName = new HashMap();
    private boolean isBuildingPipelineOnly;
    private ComponentManager currentManager;
    private ComponentManager pipelinesManager;
    private Logger logger;
    protected String processingPipelineName;
    protected Map processingPipelineParameters;
    protected Map processingPipelineObjectModel;
    protected ProcessingPipeline processingPipeline;
    protected ComponentSelector pipelineSelector;

    public InvokeContext() {
        this.isBuildingPipelineOnly = false;
    }

    public boolean pipelineIsSet() {
        return this.processingPipeline != null;
    }

    public InvokeContext(boolean isBuildingPipelineOnly) {
        this.isBuildingPipelineOnly = isBuildingPipelineOnly;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.currentManager = manager;
    }

    public void recompose(ComponentManager manager) throws ComponentException {
        this.currentManager = manager;
        if (this.processingPipeline != null) {
            this.processingPipeline.recompose(manager);
        }
    }

    public void inform(String pipelineName, Map parameters, Map objectModel) {
        this.processingPipelineName = pipelineName;
        this.processingPipelineParameters = parameters;
        this.processingPipelineObjectModel = objectModel;
    }

    public ProcessingPipeline getProcessingPipeline() throws Exception {
        if (this.processingPipeline == null) {
            this.pipelinesManager = this.currentManager;
            this.pipelineSelector = (ComponentSelector)this.pipelinesManager.lookup(ProcessingPipeline.ROLE + "Selector");
            this.processingPipeline = (ProcessingPipeline)this.pipelineSelector.select((Object)this.processingPipelineName);
            this.processingPipeline.recompose(this.pipelinesManager);
            this.processingPipeline.setup(VariableResolver.buildParameters(this.processingPipelineParameters, this, this.processingPipelineObjectModel));
            if (this.isBuildingPipelineOnly) {
                CocoonComponentManager.addComponentForAutomaticRelease(this.pipelineSelector, this.processingPipeline, this.pipelinesManager);
            }
        }
        return this.processingPipeline;
    }

    public void setProcessingPipeline(ProcessingPipeline pipeline) {
        this.processingPipeline = pipeline;
    }

    public final boolean isBuildingPipelineOnly() {
        return this.isBuildingPipelineOnly;
    }

    public final List getMapStack() {
        return this.mapStack;
    }

    public final Map getMapByAnchor(String anchor) {
        return (Map)this.nameToMap.get(anchor);
    }

    public final void pushMap(String anchorName, Map map) {
        this.mapStack.add(map);
        if (this.logger.isDebugEnabled()) {
            this.dumpParameters();
        }
        if (anchorName != null) {
            if (!this.nameToMap.containsKey(anchorName)) {
                this.nameToMap.put(anchorName, map);
                this.mapToName.put(map, anchorName);
            } else if (this.logger.isErrorEnabled()) {
                this.logger.error("name [" + anchorName + "] clashes");
            }
        }
    }

    protected void dumpParameters() {
        if (!this.mapStack.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("\nCurrent Sitemap Parameters:\n");
            String path = "";
            int i = this.mapStack.size() - 1;
            while (i >= 0) {
                Map map = (Map)this.mapStack.get(i);
                sb.append("LEVEL ").append(i + 1);
                if (this.mapToName.containsKey(map)) {
                    sb.append(" is named '").append(String.valueOf(this.mapToName.get(map))).append("'");
                }
                sb.append("\n");
                Iterator keys = map.keySet().iterator();
                while (keys.hasNext()) {
                    Object key = keys.next();
                    sb.append("PARAM: '").append(path).append(key).append("' ");
                    sb.append("VALUE: '").append(map.get(key)).append("'\n");
                }
                path = "../" + path;
                --i;
            }
            this.logger.debug(sb.toString());
        }
    }

    public final void popMap() {
        Object map = this.mapStack.remove(this.mapStack.size() - 1);
        Object name = this.mapToName.get(map);
        this.mapToName.remove(map);
        this.nameToMap.remove(name);
    }

    public final void reset() {
        this.mapStack.clear();
        this.mapToName.clear();
        this.nameToMap.clear();
        this.dispose();
    }

    public void dispose() {
        if (!this.isBuildingPipelineOnly && this.pipelinesManager != null) {
            if (this.pipelineSelector != null) {
                this.pipelineSelector.release((Component)this.processingPipeline);
                this.processingPipeline = null;
                this.pipelinesManager.release((Component)this.pipelineSelector);
                this.pipelineSelector = null;
            }
            this.pipelinesManager = null;
            this.processingPipelineParameters = null;
        }
    }
}

