/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.util.StringUtils;

public abstract class AbstractParentProcessingNodeBuilder
extends AbstractProcessingNodeBuilder
implements Configurable {
    protected Collection allowedChildren;
    protected Collection forbiddenChildren;
    protected Collection ignoredChildren;

    public void configure(Configuration config) throws ConfigurationException {
        this.allowedChildren = this.getStringCollection(config.getChild("allowed-children"));
        this.forbiddenChildren = this.getStringCollection(config.getChild("forbidden-children"));
        this.ignoredChildren = this.getStringCollection(config.getChild("ignored-children"));
    }

    protected boolean isChild(Configuration child) throws ConfigurationException {
        this.checkNamespace(child);
        String name = child.getName();
        if (this.isParameter(child)) {
            return false;
        }
        if (this.ignoredChildren != null && this.ignoredChildren.contains(name)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Element '" + name + "' is ignored for building children of element '" + child.getName() + "'");
            }
            return false;
        }
        if (this.allowedChildren != null && !this.allowedChildren.contains(name) || this.forbiddenChildren != null && this.forbiddenChildren.contains(name)) {
            String msg = "Element '" + name + "' is not allowed at " + child.getLocation();
            throw new ConfigurationException(msg);
        }
        return true;
    }

    protected boolean isParameter(Configuration config) throws ConfigurationException {
        String name = config.getName();
        if (name.equals(this.treeBuilder.getParameterName())) {
            if (this.hasParameters()) {
                return true;
            }
            String msg = "Element '" + name + "' has no parameters at " + config.getLocation();
            throw new ConfigurationException(msg);
        }
        return false;
    }

    protected List buildChildNodesList(Configuration config) throws Exception {
        Configuration[] children = config.getChildren();
        ArrayList<ProcessingNode> result = new ArrayList<ProcessingNode>();
        int i = 0;
        while (i < children.length) {
            Configuration child = children[i];
            try {
                if (this.isChild(child)) {
                    ProcessingNodeBuilder childBuilder = this.treeBuilder.createNodeBuilder(child);
                    result.add(childBuilder.buildNode(child));
                }
            }
            catch (ConfigurationException ce) {
                throw ce;
            }
            catch (Exception e) {
                String msg = "Error while creating node '" + child.getName() + "' at " + child.getLocation();
                throw new ConfigurationException(msg, (Throwable)e);
            }
            ++i;
        }
        return result;
    }

    protected ProcessingNode[] buildChildNodes(Configuration config) throws Exception {
        return AbstractParentProcessingNodeBuilder.toNodeArray(this.buildChildNodesList(config));
    }

    public static ProcessingNode[] toNodeArray(List list) {
        return list.toArray(new ProcessingNode[list.size()]);
    }

    private Collection getStringCollection(Configuration config) {
        String s = config.getValue(null);
        return s == null ? null : Arrays.asList(StringUtils.split(s, ", \t\n\r"));
    }
}

