/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.CacheValidityToSourceValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.CachingOutputStream;
import org.apache.cocoon.caching.ComponentCacheKey;
import org.apache.cocoon.caching.PipelineCacheKey;
import org.apache.cocoon.components.pipeline.impl.BaseCachingProcessingPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;

public abstract class AbstractCachingProcessingPipeline
extends BaseCachingProcessingPipeline {
    protected String generatorRole;
    protected ArrayList transformerRoles = new ArrayList();
    protected String serializerRole;
    protected String readerRole;
    protected byte[] cachedResponse;
    protected long cachedLastModified;
    protected int firstProcessedTransformerIndex;
    protected boolean completeResponseIsCached;
    protected PipelineCacheKey fromCacheKey;
    protected PipelineCacheKey toCacheKey;
    protected SourceValidity[] toCacheSourceValidities;
    protected int firstNotCacheableTransformerIndex;
    protected boolean cacheCompleteResponse;
    protected boolean generatorIsCacheableProcessingComponent;
    protected boolean serializerIsCacheableProcessingComponent;
    protected boolean[] transformerIsCacheableProcessingComponent;
    protected boolean doSmartCaching;
    protected boolean configuredDoSmartCaching;

    protected abstract void cacheResults(Environment var1, OutputStream var2) throws Exception;

    protected abstract ComponentCacheKey newComponentCacheKey(int var1, String var2, Serializable var3);

    protected abstract void connectCachingPipeline(Environment var1) throws ProcessingException;

    public void parameterize(Parameters params) throws ParameterException {
        super.parameterize(params);
        this.configuredDoSmartCaching = params.getParameterAsBoolean("smart-caching", true);
    }

    public void setup(Parameters params) {
        super.setup(params);
        this.doSmartCaching = params.getParameterAsBoolean("smart-caching", this.configuredDoSmartCaching);
    }

    public void setGenerator(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        super.setGenerator(role, source, param, hintParam);
        this.generatorRole = role;
    }

    public void addTransformer(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        super.addTransformer(role, source, param, hintParam);
        this.transformerRoles.add(role);
    }

    public void setSerializer(String role, String source, Parameters param, Parameters hintParam, String mimeType) throws ProcessingException {
        super.setSerializer(role, source, param, hintParam, mimeType);
        this.serializerRole = role;
    }

    public void setReader(String role, String source, Parameters param, String mimeType) throws ProcessingException {
        super.setReader(role, source, param, mimeType);
        this.readerRole = role;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean processXMLPipeline(Environment environment) throws ProcessingException {
        if (this.toCacheKey == null && this.cachedResponse == null) {
            return super.processXMLPipeline(environment);
        }
        if (this.cachedResponse != null && this.completeResponseIsCached) {
            if (super.checkIfModified(environment, this.cachedLastModified)) {
                return true;
            }
            try {
                OutputStream outputStream = environment.getOutputStream(0);
                if (this.cachedResponse.length <= 0) return true;
                environment.setContentLength(this.cachedResponse.length);
                outputStream.write(this.cachedResponse);
                return true;
            }
            catch (SocketException socketException) {
                if (socketException.getMessage().indexOf("reset") <= 0 && socketException.getMessage().indexOf("aborted") <= 0 && socketException.getMessage().indexOf("connection abort") <= 0) throw new ProcessingException("Failed to execute pipeline.", socketException);
                throw new ConnectionResetException("Connection reset by peer", socketException);
            }
            catch (Exception e) {
                if (!(e instanceof ProcessingException)) throw new ProcessingException("Error executing pipeline.", e);
                throw (ProcessingException)((Object)e);
            }
        }
        if (this.getLogger().isDebugEnabled() && this.toCacheKey != null) {
            this.getLogger().debug("processXMLPipeline: caching content for further requests of '" + environment.getURI() + "' using key " + this.toCacheKey);
        }
        try {
            void var2_13;
            void var2_6;
            Object var2_4 = null;
            if (this.cacheCompleteResponse && this.toCacheKey != null) {
                CachingOutputStream cachingOutputStream = new CachingOutputStream(environment.getOutputStream(this.outputBufferSize));
            }
            if (this.serializer != this.lastConsumer) {
                if (var2_6 == null) {
                    OutputStream outputStream = environment.getOutputStream(this.outputBufferSize);
                }
                if (this.xmlDeserializer != null) {
                    this.xmlDeserializer.deserialize(this.cachedResponse);
                } else {
                    this.generator.generate();
                }
            } else if (this.serializer.shouldSetContentLength()) {
                void var2_10;
                if (var2_6 == null) {
                    OutputStream outputStream = environment.getOutputStream(0);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.serializer.setOutputStream(baos);
                if (this.xmlDeserializer != null) {
                    this.xmlDeserializer.deserialize(this.cachedResponse);
                } else {
                    this.generator.generate();
                }
                environment.setContentLength(baos.size());
                baos.writeTo((OutputStream)var2_10);
            } else {
                void var2_12;
                if (var2_6 == null) {
                    OutputStream outputStream = environment.getOutputStream(this.outputBufferSize);
                }
                this.serializer.setOutputStream((OutputStream)var2_12);
                if (this.xmlDeserializer != null) {
                    this.xmlDeserializer.deserialize(this.cachedResponse);
                } else {
                    this.generator.generate();
                }
            }
            this.cacheResults(environment, (OutputStream)var2_13);
            return true;
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().indexOf("reset") <= 0 && socketException.getMessage().indexOf("aborted") <= 0 && socketException.getMessage().indexOf("connection abort") <= 0) throw new ProcessingException("Failed to execute pipeline.", socketException);
            throw new ConnectionResetException("Connection reset by peer", socketException);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to execute pipeline.", e);
        }
    }

    protected void generateCachingKey(Environment environment) throws ProcessingException {
        this.toCacheKey = null;
        Serializable key = null;
        this.generatorIsCacheableProcessingComponent = false;
        this.serializerIsCacheableProcessingComponent = false;
        this.transformerIsCacheableProcessingComponent = new boolean[this.transformers.size()];
        this.firstNotCacheableTransformerIndex = 0;
        this.cacheCompleteResponse = false;
        if (this.generator instanceof CacheableProcessingComponent) {
            key = ((CacheableProcessingComponent)((Object)this.generator)).getKey();
            this.generatorIsCacheableProcessingComponent = true;
        } else if (this.generator instanceof Cacheable) {
            key = new Long(((Cacheable)((Object)this.generator)).generateKey());
        }
        if (key != null) {
            this.toCacheKey = new PipelineCacheKey();
            this.toCacheKey.addKey(this.newComponentCacheKey(1, this.generatorRole, key));
            int transformerSize = this.transformers.size();
            boolean continueTest = true;
            while (this.firstNotCacheableTransformerIndex < transformerSize && continueTest) {
                Transformer trans = (Transformer)this.transformers.get(this.firstNotCacheableTransformerIndex);
                key = null;
                if (trans instanceof CacheableProcessingComponent) {
                    key = ((CacheableProcessingComponent)((Object)trans)).getKey();
                    this.transformerIsCacheableProcessingComponent[this.firstNotCacheableTransformerIndex] = true;
                } else if (trans instanceof Cacheable) {
                    key = new Long(((Cacheable)((Object)trans)).generateKey());
                }
                if (key != null) {
                    this.toCacheKey.addKey(this.newComponentCacheKey(3, (String)this.transformerRoles.get(this.firstNotCacheableTransformerIndex), key));
                    ++this.firstNotCacheableTransformerIndex;
                    continue;
                }
                continueTest = false;
            }
            if (this.firstNotCacheableTransformerIndex == transformerSize && this.serializer == this.lastConsumer) {
                key = null;
                if (this.serializer instanceof CacheableProcessingComponent) {
                    key = ((CacheableProcessingComponent)((Object)this.serializer)).getKey();
                    this.serializerIsCacheableProcessingComponent = true;
                } else if (this.serializer instanceof Cacheable) {
                    key = new Long(((Cacheable)((Object)this.serializer)).generateKey());
                }
                if (key != null) {
                    this.toCacheKey.addKey(this.newComponentCacheKey(5, this.serializerRole, key));
                    this.cacheCompleteResponse = true;
                }
            }
        }
    }

    protected void setupValidities() throws ProcessingException {
        if (this.toCacheKey != null) {
            if (this.fromCacheKey == null || this.fromCacheKey.size() < this.toCacheKey.size()) {
                this.toCacheSourceValidities = new SourceValidity[this.toCacheKey.size()];
                int len = this.toCacheSourceValidities.length;
                int i = 0;
                while (i < len) {
                    SourceValidity validity = this.getValidityForInternalPipeline(i);
                    if (validity == null) {
                        if (i > 0 && (this.fromCacheKey == null || i > this.fromCacheKey.size())) {
                            int m = i;
                            while (m < this.toCacheSourceValidities.length) {
                                this.toCacheKey.removeLastKey();
                                if (!this.cacheCompleteResponse) {
                                    --this.firstNotCacheableTransformerIndex;
                                }
                                this.cacheCompleteResponse = false;
                                ++m;
                            }
                            SourceValidity[] copy = new SourceValidity[i];
                            System.arraycopy(this.toCacheSourceValidities, 0, copy, 0, copy.length);
                            this.toCacheSourceValidities = copy;
                            len = this.toCacheSourceValidities.length;
                        } else {
                            this.toCacheKey = null;
                            this.toCacheSourceValidities = null;
                            this.cacheCompleteResponse = false;
                            len = 0;
                        }
                    } else {
                        this.toCacheSourceValidities[i] = validity;
                    }
                    ++i;
                }
            } else {
                this.toCacheKey = null;
                this.cacheCompleteResponse = false;
            }
        }
    }

    protected void validatePipeline(Environment environment) throws ProcessingException {
        this.completeResponseIsCached = this.cacheCompleteResponse;
        this.fromCacheKey = this.toCacheKey.copy();
        this.firstProcessedTransformerIndex = this.firstNotCacheableTransformerIndex;
        this.cachedLastModified = 0L;
        boolean finished = false;
        while (this.fromCacheKey != null && !finished) {
            finished = true;
            CachedResponse response = this.cache.get(this.fromCacheKey);
            if (response != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Found cached response for '" + environment.getURI() + "' using key: " + this.fromCacheKey);
                }
                boolean responseIsValid = true;
                boolean responseIsUsable = true;
                Long responseExpires = response.getExpires();
                if (responseExpires != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Expires time found for " + environment.getURI());
                    }
                    if (responseExpires > System.currentTimeMillis()) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Expires time still fresh for " + environment.getURI() + ", ignoring all other cache settings. This entry expires on " + new Date(responseExpires));
                        }
                        this.cachedResponse = response.getResponse();
                        this.cachedLastModified = response.getLastModified();
                        return;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Expires time has expired for " + environment.getURI() + " regenerating content.");
                    }
                    if (this.expires != 0L) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Refreshing expires informations");
                        }
                        response.setExpires(new Long(this.expires + System.currentTimeMillis()));
                    } else {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("No expires defined anymore for this object, setting it to no expires");
                        }
                        response.setExpires(null);
                    }
                } else if (this.expires != 0L) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Setting a new expires object for this resource");
                    }
                    response.setExpires(new Long(this.expires + System.currentTimeMillis()));
                }
                SourceValidity[] fromCacheValidityObjects = response.getValidityObjects();
                int i = 0;
                while (responseIsValid && i < fromCacheValidityObjects.length) {
                    int valid;
                    boolean isValid = false;
                    SourceValidity validity = fromCacheValidityObjects[i];
                    int n = valid = validity != null ? validity.isValid() : -1;
                    if (valid == 0) {
                        validity = this.getValidityForInternalPipeline(i);
                        if (validity != null) {
                            valid = fromCacheValidityObjects[i].isValid(validity);
                            if (valid == 0) {
                                validity = null;
                            } else {
                                isValid = valid == 1;
                            }
                        }
                    } else {
                        boolean bl = isValid = valid == 1;
                    }
                    if (!isValid) {
                        responseIsValid = false;
                        if (validity == null) {
                            responseIsUsable = false;
                            if (!this.getLogger().isDebugEnabled()) continue;
                            this.getLogger().debug("validatePipeline: responseIsUsable is false, valid==" + valid + " at index " + i);
                            continue;
                        }
                        if (!this.getLogger().isDebugEnabled()) continue;
                        this.getLogger().debug("validatePipeline: responseIsValid is false due to " + validity);
                        continue;
                    }
                    ++i;
                }
                if (responseIsValid) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("validatePipeline: using valid cached content for '" + environment.getURI() + "'.");
                    }
                    this.cachedResponse = response.getResponse();
                    this.cachedLastModified = response.getLastModified();
                    continue;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("validatePipeline: cached content is invalid for '" + environment.getURI() + "'.");
                }
                if (!responseIsUsable) {
                    if (i > 0) {
                        int deleteCount = fromCacheValidityObjects.length - i;
                        if (i > 0 && i <= this.firstNotCacheableTransformerIndex + 1) {
                            this.firstNotCacheableTransformerIndex = i - 1;
                        }
                        int x = 0;
                        while (x < deleteCount) {
                            this.toCacheKey.removeLastKey();
                            ++x;
                        }
                        finished = false;
                    } else {
                        this.toCacheKey = null;
                    }
                    this.cacheCompleteResponse = false;
                } else {
                    this.cache.remove(this.fromCacheKey);
                }
                if (i > 0) {
                    this.fromCacheKey.removeLastKey();
                    if (!this.completeResponseIsCached) {
                        --this.firstProcessedTransformerIndex;
                    }
                } else {
                    this.fromCacheKey = null;
                }
                finished = false;
                this.completeResponseIsCached = false;
                continue;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Cached response not found for '" + environment.getURI() + "' using key: " + this.fromCacheKey);
            }
            if (!this.doSmartCaching) {
                if (this.fromCacheKey.size() > 1) {
                    this.fromCacheKey.removeLastKey();
                    if (!this.completeResponseIsCached) {
                        --this.firstProcessedTransformerIndex;
                    }
                    finished = false;
                } else {
                    this.fromCacheKey = null;
                }
            } else {
                this.fromCacheKey = null;
            }
            this.completeResponseIsCached = false;
        }
    }

    protected void setupPipeline(Environment environment) throws ProcessingException {
        super.setupPipeline(environment);
        this.generateCachingKey(environment);
        if (this.toCacheKey != null) {
            this.validatePipeline(environment);
        }
        this.setupValidities();
    }

    protected void connectPipeline(Environment environment) throws ProcessingException {
        if (this.toCacheKey == null && this.cachedResponse == null) {
            super.connectPipeline(environment);
            return;
        }
        if (this.completeResponseIsCached) {
            return;
        }
        this.connectCachingPipeline(environment);
    }

    protected boolean processReader(Environment environment) throws ProcessingException {
        try {
            boolean usedCache = false;
            OutputStream outputStream = null;
            SourceValidity readerValidity = null;
            PipelineCacheKey pcKey = null;
            Serializable readerKey = null;
            boolean isCacheableProcessingComponent = false;
            if (this.reader instanceof CacheableProcessingComponent) {
                readerKey = ((CacheableProcessingComponent)((Object)this.reader)).getKey();
                isCacheableProcessingComponent = true;
            } else if (this.reader instanceof Cacheable) {
                readerKey = new Long(((Cacheable)((Object)this.reader)).generateKey());
            }
            if (readerKey != null) {
                pcKey = new PipelineCacheKey();
                pcKey.addKey(new ComponentCacheKey(7, this.readerRole, readerKey));
                CachedResponse cachedObject = this.cache.get(pcKey);
                if (cachedObject != null) {
                    SourceValidity[] validities;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Found cached response for '" + environment.getURI() + "' using key: " + pcKey);
                    }
                    if ((validities = cachedObject.getValidityObjects()) == null || validities.length != 1) {
                        this.cache.remove(pcKey);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Cached response for '" + environment.getURI() + "' using key: " + pcKey + " is invalid.");
                        }
                        this.cachedResponse = null;
                    } else {
                        SourceValidity cachedValidity = validities[0];
                        int result = cachedValidity.isValid();
                        boolean valid = false;
                        if (result == 0) {
                            if (isCacheableProcessingComponent) {
                                readerValidity = ((CacheableProcessingComponent)((Object)this.reader)).getValidity();
                            } else {
                                CacheValidity cv = ((Cacheable)((Object)this.reader)).generateValidity();
                                if (cv != null) {
                                    readerValidity = CacheValidityToSourceValidity.createValidity(cv);
                                }
                            }
                            if (readerValidity != null) {
                                result = cachedValidity.isValid(readerValidity);
                                if (result == 0) {
                                    readerValidity = null;
                                } else {
                                    valid = result == 1;
                                }
                            }
                        } else {
                            boolean bl = valid = result > 0;
                        }
                        if (valid) {
                            byte[] response;
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("processReader: using valid cached content for '" + environment.getURI() + "'.");
                            }
                            if ((response = cachedObject.getResponse()).length > 0) {
                                usedCache = true;
                                outputStream = environment.getOutputStream(0);
                                environment.setContentLength(response.length);
                                outputStream.write(response);
                            }
                        } else {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("processReader: cached content is invalid for '" + environment.getURI() + "'.");
                            }
                            this.cache.remove(pcKey);
                        }
                    }
                }
            }
            if (!usedCache) {
                if (pcKey != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("processReader: caching content for further requests of '" + environment.getURI() + "'.");
                    }
                    if (readerValidity == null) {
                        if (isCacheableProcessingComponent) {
                            readerValidity = ((CacheableProcessingComponent)((Object)this.reader)).getValidity();
                        } else {
                            CacheValidity cv = ((Cacheable)((Object)this.reader)).generateValidity();
                            if (cv != null) {
                                readerValidity = CacheValidityToSourceValidity.createValidity(cv);
                            }
                        }
                    }
                    if (readerValidity != null) {
                        outputStream = environment.getOutputStream(this.outputBufferSize);
                        outputStream = new CachingOutputStream(outputStream);
                    } else {
                        pcKey = null;
                    }
                }
                if (this.reader.shouldSetContentLength()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    this.reader.setOutputStream(os);
                    this.reader.generate();
                    environment.setContentLength(os.size());
                    if (outputStream == null) {
                        outputStream = environment.getOutputStream(0);
                    }
                    os.writeTo(environment.getOutputStream(0));
                } else {
                    if (outputStream == null) {
                        outputStream = environment.getOutputStream(this.outputBufferSize);
                    }
                    this.reader.setOutputStream(outputStream);
                    this.reader.generate();
                }
                if (pcKey != null) {
                    this.cache.store(pcKey, new CachedResponse(new SourceValidity[]{readerValidity}, ((CachingOutputStream)outputStream).getContent()));
                }
            }
        }
        catch (SocketException se) {
            if (se.getMessage().indexOf("reset") > 0 || se.getMessage().indexOf("aborted") > 0 || se.getMessage().indexOf("connection abort") > 0) {
                throw new ConnectionResetException("Connection reset by peer", se);
            }
            throw new ProcessingException("Failed to execute pipeline.", se);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to execute pipeline.", e);
        }
        return true;
    }

    public SourceValidity getValidityForEventPipeline() {
        int vals = 0;
        if (null != this.toCacheKey && !this.cacheCompleteResponse && this.firstNotCacheableTransformerIndex == this.transformers.size()) {
            vals = this.toCacheKey.size();
        } else if (null != this.fromCacheKey && !this.completeResponseIsCached && this.firstProcessedTransformerIndex == this.transformers.size()) {
            vals = this.fromCacheKey.size();
        }
        if (vals > 0) {
            AggregatedValidity validity = new AggregatedValidity();
            int i = 0;
            while (i < vals) {
                validity.add(this.getValidityForInternalPipeline(i));
                ++i;
            }
            return validity;
        }
        return null;
    }

    public String getKeyForEventPipeline() {
        if (null != this.toCacheKey && !this.cacheCompleteResponse && this.firstNotCacheableTransformerIndex == this.transformers.size()) {
            return String.valueOf(HashUtil.hash(this.toCacheKey.toString()));
        }
        if (null != this.fromCacheKey && !this.completeResponseIsCached && this.firstProcessedTransformerIndex == this.transformers.size()) {
            return String.valueOf(HashUtil.hash(this.fromCacheKey.toString()));
        }
        return null;
    }

    SourceValidity getValidityForInternalPipeline(int index) {
        SourceValidity validity;
        boolean debug = this.getLogger().isDebugEnabled();
        String msg = null;
        if (debug) {
            msg = "getValidityForInternalPipeline(" + index + "): ";
        }
        if (index == 0) {
            if (this.generatorIsCacheableProcessingComponent) {
                validity = ((CacheableProcessingComponent)((Object)this.generator)).getValidity();
                if (debug) {
                    msg = msg + "generator: using getValidity";
                }
            } else {
                validity = CacheValidityToSourceValidity.createValidity(((Cacheable)((Object)this.generator)).generateValidity());
                if (debug) {
                    msg = msg + "generator: using generateValidity";
                }
            }
        } else if (index <= this.firstNotCacheableTransformerIndex) {
            Transformer trans = (Transformer)this.transformers.get(index - 1);
            if (this.transformerIsCacheableProcessingComponent[index - 1]) {
                validity = ((CacheableProcessingComponent)((Object)trans)).getValidity();
                if (debug) {
                    msg = msg + "transformer: using getValidity";
                }
            } else {
                validity = CacheValidityToSourceValidity.createValidity(((Cacheable)((Object)trans)).generateValidity());
                if (debug) {
                    msg = msg + "transformer: using generateValidity";
                }
            }
        } else if (this.serializerIsCacheableProcessingComponent) {
            validity = ((CacheableProcessingComponent)((Object)this.serializer)).getValidity();
            if (debug) {
                msg = msg + "serializer: using getValidity";
            }
        } else {
            validity = CacheValidityToSourceValidity.createValidity(((Cacheable)((Object)this.serializer)).generateValidity());
            if (debug) {
                msg = msg + "serializer: using generateValidity";
            }
        }
        if (debug) {
            msg = msg + ", validity==" + validity;
            this.getLogger().debug(msg);
        }
        return validity;
    }

    public void recycle() {
        this.generatorRole = null;
        this.transformerRoles.clear();
        this.serializerRole = null;
        this.readerRole = null;
        this.fromCacheKey = null;
        this.cachedResponse = null;
        this.transformerIsCacheableProcessingComponent = null;
        this.toCacheKey = null;
        this.toCacheSourceValidities = null;
        super.recycle();
    }
}

