/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.ExitException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CocoonTask
extends Task
implements DynamicConfigurator {
    private CommandlineJava cmdl = new CommandlineJava();
    private boolean failOnError = false;
    private Throwable caught = null;
    private String uriGroup = null;
    private Document xconf;
    private Element root;
    private ElementWrapper _wrapper;
    private static final String CLASS_DELEGATE = "org.apache.cocoon.bean.helpers.AntDelegate";

    public CocoonTask() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.xconf = builder.newDocument();
            this.root = this.xconf.createElement("cocoon");
            this.xconf.appendChild(this.root);
            this._wrapper = new ElementWrapper((Node)this.root);
            this.cmdl.setClassname(CLASS_DELEGATE);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public Path createClasspath() {
        return this.cmdl.createClasspath(this.getProject()).createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public void setUrigroup(String group) {
        this.uriGroup = group;
    }

    public File getLibDir() throws BuildException {
        Element root = this.xconf.getDocumentElement();
        String contextDir = null;
        if (root != null && CocoonTask.hasAttribute(root, "context-dir")) {
            contextDir = CocoonTask.getAttributeValue(root, "context-dir");
        }
        if (contextDir != null) {
            return new File(contextDir + "/WEB-INF/lib");
        }
        throw new BuildException("No context directory specified. Cannot find Cocoon");
    }

    private static String getAttributeValue(Node node, String attr) throws IllegalArgumentException {
        Node attribute;
        NamedNodeMap nodes = node.getAttributes();
        if (nodes != null && (attribute = nodes.getNamedItem(attr)) != null && attribute.getNodeValue() != null) {
            return attribute.getNodeValue();
        }
        throw new IllegalArgumentException("Missing " + attr + " attribute on <" + node.getNodeName() + "> node");
    }

    private static boolean hasAttribute(Node node, String attr) {
        NamedNodeMap nodes = node.getAttributes();
        if (nodes != null) {
            Node attribute = nodes.getNamedItem(attr);
            return attribute != null;
        }
        return false;
    }

    public void setDynamicAttribute(String name, String value) throws BuildException {
        this.root.setAttribute(name, value);
    }

    public Object createDynamicElement(String name) throws BuildException {
        return this._wrapper.createDynamicElement(name);
    }

    public void execute() throws BuildException {
        int err = -1;
        if (this.cmdl.getClasspath() == null) {
            throw new BuildException("Could not find a classpath that points to the Cocoon classes");
        }
        try {
            try {
                this.execute(this.cmdl);
                err = 0;
            }
            catch (ExitException ex) {
                err = ex.getStatus();
            }
        }
        catch (BuildException e) {
            if (this.failOnError) {
                throw e;
            }
            this.log(e.getMessage(), 0);
            err = 0;
        }
        catch (Throwable t) {
            if (this.failOnError) {
                throw new BuildException(t);
            }
            this.log(t.getMessage(), 0);
            err = 0;
        }
    }

    public void execute(CommandlineJava command) throws BuildException {
        String classname = command.getJavaCommand().getExecutable();
        AntClassLoader loader = null;
        try {
            if (command.getSystemProperties() != null) {
                command.getSystemProperties().setSystem();
            }
            Class[] param = new Class[]{Class.forName("org.w3c.dom.Document"), Class.forName("java.lang.String")};
            Class target = null;
            if (command.getClasspath() == null) {
                target = Class.forName(classname);
            } else {
                loader = new AntClassLoader(this.getProject().getCoreLoader(), this.getProject(), command.getClasspath(), false);
                loader.setIsolated(true);
                loader.setThreadContextLoader();
                target = loader.forceLoadClass(classname);
                Class.forName(classname, true, (ClassLoader)loader);
            }
            Method method = target.getMethod("process", param);
            if (method == null) {
                throw new BuildException("Could not find process() method in " + classname);
            }
            this.run(method);
            if (this.caught != null) {
                throw this.caught;
            }
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Could not find " + classname + "." + " Make sure you have it in your" + " classpath");
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BuildException(e);
        }
        finally {
            if (loader != null) {
                loader.resetThreadContextLoader();
                loader.cleanup();
            }
            if (command.getSystemProperties() != null) {
                command.getSystemProperties().restoreSystem();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Method method) {
        CocoonTask cocoonTask;
        Object[] argument = new Object[]{this.xconf, this.uriGroup};
        try {
            try {
                method.invoke(null, argument);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (!(t instanceof InterruptedException)) {
                    this.caught = t;
                }
                Object var6_4 = null;
                CocoonTask cocoonTask3 = this;
                synchronized (cocoonTask3) {
                    ((Object)((Object)this)).notifyAll();
                    return;
                }
            }
            catch (Throwable t) {
                this.caught = t;
                Object var6_5 = null;
                CocoonTask cocoonTask4 = this;
                synchronized (cocoonTask4) {
                    ((Object)((Object)this)).notifyAll();
                    return;
                }
            }
            Object var6_3 = null;
            cocoonTask = this;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CocoonTask cocoonTask2 = this;
            synchronized (cocoonTask2) {
                ((Object)((Object)this)).notifyAll();
                throw throwable;
            }
        }
        synchronized (cocoonTask) {
            ((Object)((Object)this)).notifyAll();
            return;
        }
    }

    private static class ElementWrapper
    implements DynamicConfigurator {
        private Node node;

        private ElementWrapper(Node node) {
            this.node = node;
        }

        private ElementWrapper(Node parent, String childName) {
            Document document = parent.getOwnerDocument();
            if (document == null) {
                document = (Document)parent;
            }
            this.node = document.createElement(childName);
            parent.appendChild(this.node);
        }

        public void setDynamicAttribute(String name, String value) throws BuildException {
            Element element = (Element)this.node;
            element.setAttribute(name, value);
        }

        public Object createDynamicElement(String name) throws BuildException {
            return new ElementWrapper(this.node, name);
        }
    }
}

