/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 7 oct. 2002
 * Time: 14:05:36
 * To change template for new interface use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.sdx.search.lucene.query.Index;
import fr.gouv.culture.sdx.utils.database.Database;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.logger.LogEnabled;

public interface IDGenerator extends LogEnabled, Configurable {
    String CLASS_NAME = "IDGenerator";
    /** The element used to define an id generator. */
    String ELEMENT_NAME_ID_GENERATOR = "idGenerator";
    /** Default value for this attribute. */
    String ATTRIBUTE_VALUE_DEFAULT_ID_GENERATOR_CLASS = "fr.gouv.culture.sdx.documentbase.DefaultIDGenerator";
    /** The attribute used to define a class for an id generator. */
    String ATTRIBUTE_CLASS = "class";

    /**Generates an id appending the given strings
     *
     * @param prefix    The prefix for the generated id
     * @param suffix    The suffix for the generated id
     * */
    String generate(String prefix, String suffix);

    /**Generates an id using configured prefix and suffix*/
    String generate();

    /**Sets the index for verification of a generated id's uniqueness
     *
     * @deprecated  This was dependency on our Lucene packages
     */
    void setIndex(Index index);

    /**Sets the database for verification of a generated id's uniqueness*/
    void setDatabase(Database database);

    /**Determines where an id is unique within an index*/
    boolean isIdUnique(String id);

    /**Set's the field name for the id field in the index for id verification needs
     *
     * @deprecated No longer necesssary as we now use Database for id verification
     */
    void setIdFieldName(String fieldName);

    String getSuffix();

    void setSuffix(String idSuffix);

    String getPrefix();

    void setPrefix(String idPrefix);

}
