/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.oai;

import fr.gouv.culture.util.apache.cocoon.xml.SynchronizedXMLPipe;
import org.apache.avalon.framework.configuration.Configurable;
import org.xml.sax.SAXException;

/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Apr 24, 2003
 * Time: 12:18:57 PM
 * To change this template use Options | File Templates.
 */

/**Basic interface for an OAI harvester
 *
 */
public interface OAIHarvester extends OAIObject, Configurable, SynchronizedXMLPipe {

    /**Gets the admin emails for this harvester*/
    String[] getAdminEmails();

    /**Sets the admin emails for this harvester*/
    void setAdminEmails(String[] adminEmails);

    /**Sets the name of the element or the value of the
     * attribute with the name "name" such that url pointers
     * to oai records can be read from repository responses
     * @param name
     */
    void setIdentifierName(String name);

    /**Shows past harvesting request data, if a null handler is provided events should be sent
     * to any consumer, handler, etc. which was previously set*/
    void sendPastHarvestsSummary() throws SAXException;

    /**Shows stored harvesting request data, if a null handler is provided events should be sent
     * to any consumer, handler, etc. which was previously set*/
    void sendStoredHarvestingRequests() throws SAXException;


    /**Removes all data from datastructures concerning past harvests*/
    void purgePastHarvestsData();

    /**Makes a request using the provided url and consumes the events WITHOUT synchronization
     * Assumes that synchronization is handled by caller
     *
     *
     */
    void receiveRequest(String requestUrl);

    /**Makes a request using the provided url and consumes the events WITH synchronization*/
    void receiveSynchronizedRequest(String requestUrl);
    
    /**Makes a request using the provided url and consumes the events WITH synchronization
     * The original request may be change according past harvests to get new documents since the last harvest date. 
     * */
    void receiveSynchronizedRequest(String requestUrl, String originalRequestUrl);

}
