/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.tools.jpeg;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.jfor.jfor.tools.jpeg.DCT;
import org.jfor.jfor.tools.jpeg.Huffman;
import org.jfor.jfor.tools.jpeg.JPEGException;
import org.jfor.jfor.tools.jpeg.JpegInfo;

public class Encoder
extends Component {
    private BufferedOutputStream outStream = null;
    private JpegInfo jpegObj = null;
    private Huffman huf = null;
    private DCT dct = null;
    private int quality;
    public static int[] jpegNaturalOrder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public Encoder(int n, OutputStream outputStream) {
        this.outStream = this.outStream = new BufferedOutputStream(outputStream);
        this.quality = n;
    }

    public void encodeJPEG(Image image) throws JPEGException {
        this.process(image);
    }

    public void encodeJPEG(URL uRL) throws JPEGException {
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.process(image);
    }

    public void encodeJPEG(byte[] byArray) throws JPEGException {
        Image image = Toolkit.getDefaultToolkit().createImage(byArray);
        this.process(image);
    }

    private void process(Image image) throws JPEGException {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setQuality(this.quality);
        this.jpegObj = new JpegInfo(image);
        this.huf = new Huffman();
        this.compress();
        this.dispose();
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int n) {
        this.quality = n;
        this.dct = new DCT(n);
    }

    private void dispose() {
        if (this.jpegObj != null) {
            this.jpegObj.dispose();
            this.jpegObj = null;
        }
        if (this.huf != null) {
            this.huf.dispose();
            this.huf = null;
        }
        if (this.dct != null) {
            this.dct.dispose();
            this.dct = null;
        }
    }

    private void compress() throws JPEGException {
        this.WriteHeaders(this.outStream);
        this.WriteCompressedData(this.outStream);
        this.WriteEOI(this.outStream);
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            throw new JPEGException(iOException);
        }
    }

    private void WriteEOI(BufferedOutputStream bufferedOutputStream) {
        byte[] byArray = new byte[]{-1, -39};
        this.WriteMarker(byArray, bufferedOutputStream);
    }

    private void WriteHeaders(BufferedOutputStream bufferedOutputStream) {
        int n;
        byte[] byArray = new byte[]{-1, -40};
        this.WriteMarker(byArray, bufferedOutputStream);
        byte[] byArray2 = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        this.WriteArray(byArray2, bufferedOutputStream);
        String string = new String();
        string = this.jpegObj.getComment();
        int n2 = string.length();
        byte[] byArray3 = new byte[n2 + 4];
        byArray3[0] = -1;
        byArray3[1] = -2;
        byArray3[2] = (byte)(n2 >> 8 & 0xFF);
        byArray3[3] = (byte)(n2 & 0xFF);
        System.arraycopy(this.jpegObj.getComment().getBytes(), 0, byArray3, 4, this.jpegObj.getComment().length());
        this.WriteArray(byArray3, bufferedOutputStream);
        byte[] byArray4 = new byte[134];
        byArray4[0] = -1;
        byArray4[1] = -37;
        byArray4[2] = 0;
        byArray4[3] = -124;
        int n3 = 4;
        int n4 = 0;
        while (n4 < 2) {
            byArray4[n3++] = (byte)(0 + n4);
            int[] nArray = this.dct.getQuantumArray(n4);
            n = 0;
            while (n < 64) {
                byArray4[n3++] = (byte)nArray[jpegNaturalOrder[n]];
                ++n;
            }
            ++n4;
        }
        this.WriteArray(byArray4, bufferedOutputStream);
        byte[] byArray5 = new byte[19];
        byArray5[0] = -1;
        byArray5[1] = -64;
        byArray5[2] = 0;
        byArray5[3] = 17;
        byArray5[4] = (byte)JpegInfo.PRECISION;
        byArray5[5] = (byte)(this.jpegObj.getImageHeight() >> 8 & 0xFF);
        byArray5[6] = (byte)(this.jpegObj.getImageHeight() & 0xFF);
        byArray5[7] = (byte)(this.jpegObj.getImageWidth() >> 8 & 0xFF);
        byArray5[8] = (byte)(this.jpegObj.getImageWidth() & 0xFF);
        byArray5[9] = (byte)this.jpegObj.getNumberOfComponents();
        int n5 = 10;
        n4 = 0;
        while (n4 < byArray5[9]) {
            int n6 = n5++;
            byArray5[n6] = (byte)JpegInfo.COMP_ID[n4];
            int n7 = n5++;
            byArray5[n7] = (byte)((JpegInfo.H_SAMP_FACTOR[n4] << 4) + JpegInfo.V_SAMP_FACTOR[n4]);
            int n8 = n5++;
            byArray5[n8] = (byte)JpegInfo.Q_TABLE_NUMBER[n4];
            ++n4;
        }
        this.WriteArray(byArray5, bufferedOutputStream);
        n2 = 2;
        n5 = 4;
        int n9 = 4;
        byte[] byArray6 = new byte[17];
        byte[] byArray7 = new byte[4];
        byArray7[0] = -1;
        byArray7[1] = -60;
        n4 = 0;
        while (n4 < 4) {
            int n10 = 0;
            byArray6[n5++ - n9] = (byte)this.huf.getBits(n4)[0];
            n = 1;
            while (n < 17) {
                int n11 = this.huf.getBits(n4)[n];
                byArray6[n5++ - n9] = (byte)n11;
                n10 += n11;
                ++n;
            }
            int n12 = n5;
            byte[] byArray8 = new byte[n10];
            n = 0;
            while (n < n10) {
                byArray8[n5++ - n12] = (byte)this.huf.getVal(n4)[n];
                ++n;
            }
            byte[] byArray9 = new byte[n5];
            System.arraycopy(byArray7, 0, byArray9, 0, n9);
            System.arraycopy(byArray6, 0, byArray9, n9, 17);
            System.arraycopy(byArray8, 0, byArray9, n9 + 17, n10);
            byArray7 = byArray9;
            n9 = n5;
            ++n4;
        }
        byArray7[2] = (byte)(n5 - 2 >> 8 & 0xFF);
        byArray7[3] = (byte)(n5 - 2 & 0xFF);
        this.WriteArray(byArray7, bufferedOutputStream);
        byte[] byArray10 = new byte[14];
        byArray10[0] = -1;
        byArray10[1] = -38;
        byArray10[2] = 0;
        byArray10[3] = 12;
        byArray10[4] = (byte)this.jpegObj.getNumberOfComponents();
        n5 = 5;
        n4 = 0;
        while (n4 < byArray10[4]) {
            int n13 = n5++;
            byArray10[n13] = (byte)JpegInfo.COMP_ID[n4];
            int n14 = n5++;
            byArray10[n14] = (byte)((JpegInfo.D_C_TABLE_NUMBER[n4] << 4) + JpegInfo.A_C_TABLE_NUMBER[n4]);
            ++n4;
        }
        int n15 = n5++;
        byArray10[n15] = (byte)JpegInfo.ss;
        int n16 = n5++;
        byArray10[n16] = (byte)JpegInfo.se;
        int n17 = n5++;
        byArray10[n17] = (byte)((JpegInfo.ah << 4) + JpegInfo.al);
        this.WriteArray(byArray10, bufferedOutputStream);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void WriteCompressedData(BufferedOutputStream bufferedOutputStream) {
        float[][] fArray = new float[8][8];
        double[][] dArray = new double[8][8];
        int[] nArray = new int[64];
        int[] nArray2 = new int[this.jpegObj.getNumberOfComponents()];
        int[] nArray3 = new int[64];
        boolean bl = false;
        int n = this.jpegObj.getImageWidth() % 8 != 0 ? (int)(Math.floor((double)this.jpegObj.getImageWidth() / 8.0) + 1.0) * 8 : this.jpegObj.getImageWidth();
        int n2 = this.jpegObj.getImageHeight() % 8 != 0 ? (int)(Math.floor((double)this.jpegObj.getImageHeight() / 8.0) + 1.0) * 8 : this.jpegObj.getImageHeight();
        int n3 = 0;
        while (n3 < this.jpegObj.getNumberOfComponents()) {
            n = Math.min(n, this.jpegObj.getBlockWidth(n3));
            n2 = Math.min(n2, this.jpegObj.getBlockHeight(n3));
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = n5 * 8;
                int n7 = n4 * 8;
                int n8 = 0;
                while (n8 < this.jpegObj.getNumberOfComponents()) {
                    int n9 = this.jpegObj.getBlockWidth(n8);
                    int n10 = this.jpegObj.getBlockHeight(n8);
                    float[][] fArray2 = (float[][])this.jpegObj.getComponent(n8);
                    int n11 = 0;
                    while (n11 < JpegInfo.V_SAMP_FACTOR[n8]) {
                        int n12 = 0;
                        while (n12 < JpegInfo.H_SAMP_FACTOR[n8]) {
                            int n13 = n12 * 8;
                            int n14 = n11 * 8;
                            int n15 = 0;
                            while (n15 < 8) {
                                int n16 = 0;
                                while (n16 < 8) {
                                    fArray[n15][n16] = fArray2[n7 + n14 + n15][n6 + n13 + n16];
                                    ++n16;
                                }
                                ++n15;
                            }
                            if (!(this.jpegObj.isLastColumnDummy(n8) && n5 >= n9 - 1 || this.jpegObj.isLastRowDummy(n8) && n4 >= n10 - 1)) {
                                dArray = this.dct.forwardDCT(fArray);
                                nArray = this.dct.quantizeBlock(dArray, JpegInfo.Q_TABLE_NUMBER[n8]);
                            } else {
                                nArray3[0] = nArray[0];
                                nArray3[0] = nArray2[n8];
                                nArray = nArray3;
                            }
                            this.huf.encodeHuffmanBlock(bufferedOutputStream, nArray, nArray2[n8], JpegInfo.D_C_TABLE_NUMBER[n8], JpegInfo.A_C_TABLE_NUMBER[n8]);
                            nArray2[n8] = nArray[0];
                            ++n12;
                        }
                        ++n11;
                    }
                    ++n8;
                }
                ++n5;
            }
            ++n4;
        }
        this.huf.flushBuffer(bufferedOutputStream);
    }

    private void WriteMarker(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            bufferedOutputStream.write(byArray, 0, 2);
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException.getMessage());
        }
    }

    private void WriteArray(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            int n = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF) + 2;
            bufferedOutputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        String string = new String();
        int n = 80;
        if (stringArray.length < 2) {
            Encoder.StandardUsage();
        }
        if (!(stringArray[0].endsWith(".jpg") || stringArray[0].endsWith(".tif") || stringArray[0].endsWith(".gif"))) {
            Encoder.StandardUsage();
        }
        if (stringArray.length < 3) {
            string = stringArray[0].substring(0, stringArray[0].lastIndexOf(".")) + ".jpg";
        } else {
            string = stringArray[2];
            if (string.endsWith(".tif") || string.endsWith(".gif")) {
                string = string.substring(0, string.lastIndexOf("."));
            }
            if (!string.endsWith(".jpg")) {
                string = string.concat(".jpg");
            }
        }
        File file = new File(string);
        int n2 = 0;
        while (file.exists()) {
            file = new File(string.substring(0, string.lastIndexOf(".")) + n2 + ".jpg");
            if (n2 > 100) {
                System.exit(0);
            }
            ++n2;
        }
        File file2 = new File(stringArray[0]);
        try {
            block19: {
                try {
                    if (file2.exists()) {
                        int n3 = n;
                        FileOutputStream fileOutputStream = null;
                        try {
                            fileOutputStream = new FileOutputStream(file);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            n3 = Integer.parseInt(stringArray[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Encoder.StandardUsage();
                        }
                        Image image = Toolkit.getDefaultToolkit().getImage(stringArray[0]);
                        Encoder encoder = new Encoder(n3, fileOutputStream);
                        encoder.encodeJPEG(image);
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                    System.out.println("I couldn't find " + stringArray[0] + ". Is it in another directory?");
                }
                catch (JPEGException jPEGException) {
                    jPEGException.printStackTrace();
                    Object var12_15 = null;
                    System.exit(0);
                    return;
                }
            }
            Object var12_14 = null;
            System.exit(0);
            return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            System.exit(0);
            throw throwable;
        }
    }

    public static void StandardUsage() {
        System.out.println("Program usage: java Jpeg \"InputImage\".\"ext\" Quality [\"OutputFile\"[.jpg]]");
        System.exit(0);
    }
}

