/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.testdocs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import org.jfor.jfor.main.JForVersionInfo;
import org.jfor.jfor.rtflib.rtfdoc.RtfDocumentArea;
import org.jfor.jfor.rtflib.rtfdoc.RtfFile;
import org.jfor.jfor.rtflib.rtfdoc.RtfParagraph;
import org.jfor.jfor.rtflib.rtfdoc.RtfSection;

abstract class TestDocument {
    private File m_output;

    TestDocument() {
    }

    final void setOutputDir(File file) throws IOException {
        this.m_output = new File(file, this.getRtfFilename());
    }

    final String getRtfFilename() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        return string.substring(n + 1) + ".rtf";
    }

    final void generateOutput() throws IOException {
        this.debugMsg("Generating document " + this.m_output + "...");
        RtfFile rtfFile = new RtfFile(new FileWriter(this.m_output));
        RtfDocumentArea rtfDocumentArea = rtfFile.startDocumentArea();
        RtfSection rtfSection = rtfDocumentArea.newSection();
        this.addIntroComments(rtfSection);
        this.generateDocument(rtfDocumentArea, rtfSection);
        rtfFile.flush();
    }

    protected abstract void generateDocument(RtfDocumentArea var1, RtfSection var2) throws IOException;

    void debugMsg(String string) {
        System.err.println(string);
    }

    protected void addIntroComments(RtfSection rtfSection) throws IOException {
        RtfParagraph rtfParagraph = rtfSection.newParagraph();
        rtfParagraph.newText("jfor RTF library test document.");
        rtfParagraph.newLineBreak();
        rtfParagraph.newText(JForVersionInfo.getLongVersionInfo());
        rtfParagraph.newLineBreak();
        rtfParagraph.newText("generated by class " + this.getClass().getName());
        rtfParagraph.newLineBreak();
        rtfParagraph.newText("generated on " + new Date());
        rtfParagraph.close();
    }
}

