/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractParticleTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDGroupTraverser
extends XSDAbstractParticleTraverser {
    XSDGroupTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
    }

    XSParticleDecl traverseLocal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_REF];
        XInt xInt = (XInt)objectArray[XSAttributeChecker.ATTIDX_MINOCCURS];
        XInt xInt2 = (XInt)objectArray[XSAttributeChecker.ATTIDX_MAXOCCURS];
        XSGroupDecl xSGroupDecl = null;
        if (qName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{"group (local)", "ref"});
        } else {
            xSGroupDecl = (XSGroupDecl)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 4, qName);
        }
        if (DOMUtil.getFirstChildElement(element) != null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (local)", "(annotation?)"});
        }
        int n = xInt.intValue();
        int n2 = xInt2.intValue();
        XSParticleDecl xSParticleDecl = null;
        if (xSGroupDecl != null && (n != 0 || n2 != 0)) {
            if (n == 1 && n2 == 1) {
                xSParticleDecl = xSGroupDecl.fParticle;
            } else if (n != 1 || n2 != 1) {
                xSParticleDecl = new XSParticleDecl();
                xSParticleDecl.fType = xSGroupDecl.fParticle.fType;
                xSParticleDecl.fValue = xSGroupDecl.fParticle;
                xSParticleDecl.fMinOccurs = n;
                xSParticleDecl.fMaxOccurs = n2;
            }
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSParticleDecl;
    }

    XSGroupDecl traverseGlobal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object object;
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, true, xSDocumentInfo);
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        if (string == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{"group (global)", "name"});
        }
        XSGroupDecl xSGroupDecl = null;
        XSParticleDecl xSParticleDecl = null;
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 == null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (global)", "(annotation?, (all | choice | sequence))"});
        } else {
            Object[] objectArray2;
            object = element2.getLocalName();
            if (((String)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(element2, objectArray, true, xSDocumentInfo);
                element2 = DOMUtil.getNextSiblingElement(element2);
                if (element2 != null) {
                    object = element2.getLocalName();
                }
            }
            if (element2 == null) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (global)", "(annotation?, (all | choice | sequence))"});
            } else if (((String)object).equals(SchemaSymbols.ELT_ALL)) {
                xSParticleDecl = this.traverseAll(element2, xSDocumentInfo, schemaGrammar, 4);
            } else if (((String)object).equals(SchemaSymbols.ELT_CHOICE)) {
                xSParticleDecl = this.traverseChoice(element2, xSDocumentInfo, schemaGrammar, 4);
            } else if (((String)object).equals(SchemaSymbols.ELT_SEQUENCE)) {
                xSParticleDecl = this.traverseSequence(element2, xSDocumentInfo, schemaGrammar, 4);
            } else {
                objectArray2 = new Object[]{"group", object};
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GroupContentRestricted", objectArray2, (short)1);
            }
            if (element2 != null && DOMUtil.getNextSiblingElement(element2) != null) {
                objectArray2 = new Object[]{"group", object};
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GroupContentRestricted", objectArray2, (short)1);
            }
            if (xSParticleDecl != null && string != null) {
                xSGroupDecl = new XSGroupDecl();
                xSGroupDecl.fName = string;
                xSGroupDecl.fTargetNamespace = xSDocumentInfo.fTargetNamespace;
                xSGroupDecl.fParticle = xSParticleDecl;
                schemaGrammar.addGlobalGroupDecl(xSGroupDecl);
            }
        }
        if (xSGroupDecl != null && (object = this.fSchemaHandler.getGrpOrAttrGrpRedefinedByRestriction(4, new QName(this.fSchemaHandler.EMPTY_STRING, string, string, xSDocumentInfo.fTargetNamespace), xSDocumentInfo)) != null) {
            schemaGrammar.addRedefinedGroupDecl(xSGroupDecl, (XSGroupDecl)object);
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSGroupDecl;
    }
}

