/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Selector;
import com.hp.hpl.mesa.rdf.jena.model.Statement;

public class SelectorImpl
implements Selector {
    protected Resource subject;
    protected Property predicate;
    protected RDFNode object;

    public SelectorImpl() {
        this.subject = null;
        this.predicate = null;
        this.object = null;
    }

    public SelectorImpl(Resource resource, Property property, RDFNode rDFNode) {
        this.subject = resource;
        this.predicate = property;
        this.object = rDFNode;
    }

    public SelectorImpl(Resource resource, Property property, boolean bl) {
        this(resource, property, new LiteralImpl(bl));
    }

    public SelectorImpl(Resource resource, Property property, long l) {
        this(resource, property, new LiteralImpl(l));
    }

    public SelectorImpl(Resource resource, Property property, char c) {
        this(resource, property, new LiteralImpl(c));
    }

    public SelectorImpl(Resource resource, Property property, float f) {
        this(resource, property, new LiteralImpl(f));
    }

    public SelectorImpl(Resource resource, Property property, double d) {
        this(resource, property, new LiteralImpl(d));
    }

    public SelectorImpl(Resource resource, Property property, String string) {
        this.subject = resource;
        this.predicate = property;
        this.object = string != null ? new LiteralImpl(string) : null;
    }

    public SelectorImpl(Resource resource, Property property, String string, String string2) {
        this.subject = resource;
        this.predicate = property;
        this.object = string != null ? new LiteralImpl(string, string2) : null;
    }

    public SelectorImpl(Resource resource, Property property, Object object) {
        this.subject = resource;
        this.predicate = property;
        this.object = object != null ? new LiteralImpl(object) : null;
    }

    public Resource getSubject() {
        return this.subject;
    }

    public Property getPredicate() {
        return this.predicate;
    }

    public RDFNode getObject() {
        return this.object;
    }

    public boolean test(Statement statement) {
        return !(this.subject != null && !this.subject.equals(statement.getSubject()) || this.predicate != null && !this.predicate.equals(statement.getPredicate()) || this.object != null && !this.object.equals(statement.getObject()) || !this.selects(statement));
    }

    public boolean selects(Statement statement) {
        return true;
    }
}

