/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.LiteralAccessor;
import com.hp.hpl.jena.daml.common.PropertyAccessorImpl;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;

public class LiteralAccessorImpl
extends PropertyAccessorImpl
implements LiteralAccessor {
    public LiteralAccessorImpl(Property property, DAMLCommon dAMLCommon) {
        super(property, dAMLCommon);
    }

    public NodeIterator getValues() {
        return this.m_val.getPropertyValues(this.getProperty());
    }

    public Literal getValue() {
        try {
            NodeIterator nodeIterator = this.getValues();
            return nodeIterator == null || !nodeIterator.hasNext() ? null : (Literal)nodeIterator.next();
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception when getting literal values: " + rDFException, rDFException);
            throw new RuntimeException("RDF exception when getting literal values: " + rDFException);
        }
    }

    public void addValue(String string) {
        try {
            this.addValue(this.m_val.getModel().createLiteral(string));
        }
        catch (RDFException rDFException) {
            Log.severe("Saw RDF Exception while creating literal: " + rDFException, rDFException);
            throw new RuntimeException("Saw RDF Exception while creating literal: " + rDFException);
        }
    }

    public void addValue(Literal literal) {
        try {
            this.m_val.addProperty(this.getProperty(), literal);
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception " + rDFException, rDFException);
        }
    }

    public void removeValue(String string) {
        try {
            this.removeValue(this.m_val.getModel().createLiteral(string));
        }
        catch (RDFException rDFException) {
            Log.severe("Saw RDF Exception while creating literal: " + rDFException, rDFException);
            throw new RuntimeException("Saw RDF Exception while creating literal: " + rDFException);
        }
    }

    public void removeValue(Literal literal) {
        this.m_val.removeProperty(this.getProperty(), literal);
    }

    public boolean hasValue(String string) {
        try {
            return this.hasValue(this.m_val.getModel().createLiteral(string));
        }
        catch (RDFException rDFException) {
            Log.severe("Saw RDF Exception while creating literal: " + rDFException, rDFException);
            throw new RuntimeException("Saw RDF Exception while creating literal: " + rDFException);
        }
    }

    public boolean hasValue(Literal literal) {
        try {
            return this.m_val.hasProperty(this.getProperty(), literal);
        }
        catch (RDFException rDFException) {
            Log.severe("RDF Exception " + rDFException, rDFException);
            throw new RuntimeException("RDF Exception " + rDFException);
        }
    }
}

