/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import com.jclark.xsl.sax.XMLProcessorImpl;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.store.Store;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.transformation.XTProcessor;
import org.apache.cocoon.xml.DocumentHandlerAdapter;
import org.apache.cocoon.xml.DocumentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.log.Logger;
import org.xml.sax.AttributeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XTTransformer
extends DocumentHandlerWrapper
implements Transformer,
Composable,
Loggable,
Disposable {
    private Logger log;
    private ComponentManager manager = null;
    private Store store = null;
    private XTProcessor processor = null;
    private DocumentHandler docHandler = null;

    public void setLogger(Logger logger) {
        if (this.log == null) {
            this.log = logger;
        }
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
        try {
            this.store = (Store)manager.lookup("org.apache.cocoon.components.store.Store/TransientCache");
        }
        catch (Exception e) {
            this.log.error("Could not find component for role org.apache.cocoon.components.store.Store/TransientCache", (Throwable)e);
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws SAXException, ProcessingException, IOException {
        String xsluri = src;
        if (xsluri == null) {
            throw new ProcessingException("Stylesheet URI can't be null");
        }
        XTProcessor loaderprocessor = null;
        if (this.store != null && (loaderprocessor = (XTProcessor)this.store.get(xsluri)) != null) {
            loaderprocessor.setLogger(this.log);
            loaderprocessor.compose(this.manager);
        }
        if (loaderprocessor == null || loaderprocessor.hasChanged()) {
            loaderprocessor = new XTProcessor();
            loaderprocessor.setLogger(this.log);
            loaderprocessor.compose(this.manager);
            SAXParser saxParser = null;
            try {
                saxParser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                this.log.error("XTTransformer.setup", (Throwable)e);
                new ProcessingException(e.getMessage(), e);
            }
            loaderprocessor.setParser(saxParser.getParser());
            Source source = resolver.resolve(xsluri);
            try {
                InputSource xslsrc = source.getInputSource();
                loaderprocessor.loadStylesheet(xslsrc);
                if (this.store != null) {
                    this.store.store(xsluri, loaderprocessor);
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                source.recycle();
                throw throwable;
            }
            source.recycle();
            {
            }
        }
        this.processor = (XTProcessor)loaderprocessor.clone();
        this.processor.setLogger(this.log);
        this.processor.compose(this.manager);
        DocHandler temp = new DocHandler(this.processor.createBuilder("XTSystemID"));
        temp.setLogger(this.log);
        this.docHandler = temp;
        this.setDocumentHandler(this.docHandler);
    }

    public void setConsumer(XMLConsumer consumer) {
        this.setContentHandler(consumer);
    }

    public void setContentHandler(ContentHandler content) {
        this.processor.setDocumentHandler(new DocumentHandlerAdapter(content));
    }

    public void setLexicalHandler(LexicalHandler lexical) {
    }

    public void dispose() {
        this.manager.release((Component)this.store);
    }

    class DocHandler
    implements DocumentHandler,
    DTDHandler,
    Loggable {
        protected Logger log;
        private XMLProcessorImpl.Builder builder = null;

        public DocHandler(XMLProcessorImpl.Builder builder) {
            this.builder = builder;
        }

        public void setLogger(Logger logger) {
            if (this.log == null) {
                this.log = logger;
            }
        }

        public void setDocumentLocator(Locator locator) {
            this.builder.setDocumentLocator(locator);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.builder.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.builder.processingInstruction(target, data);
        }

        public void startDocument() throws SAXException {
            this.builder.startDocument();
        }

        public void endDocument() throws SAXException {
            this.builder.endDocument();
            try {
                XTTransformer.this.processor.process(this.builder.getRootNode());
            }
            catch (IOException ioe) {
                this.log.error("XTTransformer", (Throwable)ioe);
                throw new SAXException(ioe);
            }
        }

        public void startElement(String name, AttributeList atts) throws SAXException {
            this.builder.startElement(name, atts);
        }

        public void endElement(String name) throws SAXException {
            this.builder.endElement(name);
        }

        public void characters(char[] str, int index, int len) throws SAXException {
            this.builder.characters(str, index, len);
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            this.builder.notationDecl(name, publicId, systemId);
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            this.builder.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }
}

