/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.generation.DirectoryGenerator;
import org.apache.log.Hierarchy;
import org.xml.sax.SAXException;

public class ImageDirectoryGenerator
extends DirectoryGenerator {
    protected static String IMAGE_WIDTH_ATTR_NAME = "width";
    protected static String IMAGE_HEIGHT_ATTR_NAME = "height";

    protected void setNodeAttributes(File path) throws SAXException {
        super.setNodeAttributes(path);
        if (path.isDirectory()) {
            return;
        }
        try {
            int[] dim = ImageDirectoryGenerator.getSize(path);
            this.getLogger().debug("getSize(path) = " + dim);
            this.attributes.addAttribute("", IMAGE_WIDTH_ATTR_NAME, IMAGE_WIDTH_ATTR_NAME, "CDATA", String.valueOf(dim[0]));
            this.attributes.addAttribute("", IMAGE_HEIGHT_ATTR_NAME, IMAGE_HEIGHT_ATTR_NAME, "CDATA", String.valueOf(dim[1]));
        }
        catch (RuntimeException e) {
            this.getLogger().debug("ImageDirectoryGenerator.setNodeAttributes", (Throwable)e);
        }
        catch (Exception e) {
            this.getLogger().error("ImageDirectoryGenerator.setNodeAttributes", (Throwable)e);
            throw new SAXException(e);
        }
    }

    public static int[] getSize(File file) throws FileNotFoundException, IOException {
        String type = ImageDirectoryGenerator.getFileType(file);
        try {
            if (type.equals("gif")) {
                return ImageDirectoryGenerator.getGifSize(file);
            }
            return ImageDirectoryGenerator.getJpegSize(file);
        }
        catch (Exception e) {
            Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("File is not a valid GIF or Jpeg", (Throwable)e);
            throw new CascadingRuntimeException("File is not a valid GIF or Jpeg", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int[] getJpegSize(File file) throws FileNotFoundException, IOException {
        in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            buf = new byte[2];
            count = in.read(buf, 0, 2);
            if (count < 2) {
                throw new RuntimeException("File " + file + " is not a valid Jpeg file!");
            }
            if (buf[0] != -1 || buf[1] != -40) {
                throw new RuntimeException("File " + file + " is not a valid Jpeg file!");
            }
            width = 0;
            height = 0;
            done = false;
            ch = 0;
            try {
                ** GOTO lbl44
                {
                    ch = in.read();
                    do {
                        if (ch != 255) continue block7;
                        while (ch == 255) {
                            ch = in.read();
                        }
                        if (ch >= 192 && ch <= 195) {
                            in.read();
                            in.read();
                            in.read();
                            height = 256 * in.read();
                            height += in.read();
                            width = 256 * in.read();
                            width += in.read();
                            done = true;
                            continue;
                        }
                        length = 256 * in.read();
                        if ((length += in.read()) < 2) {
                            throw new RuntimeException("Erroneous JPEG marker length");
                        }
                        foo = 0;
                        while (foo < length - 2) {
                            in.read();
                            ++foo;
                        }
lbl44:
                        // 3 sources

                    } while (ch != 218 && !done);
                }
            }
            catch (Exception e) {
                msg = "File " + file + " is not a valid Jpeg file!";
                Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug(msg, (Throwable)e);
                throw new CascadingRuntimeException(msg, (Throwable)e);
            }
            var9_13 = dim = new int[]{width, height};
            var11_14 = null;
            ** if (in == null) goto lbl59
        }
        catch (Throwable var10_18) {
            block16: {
                var11_15 = null;
                if (in == null) break block16;
                try {
                    in.close();
                }
                catch (Exception e) {
                    Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("Close stream", (Throwable)e);
                }
            }
            throw var10_18;
        }
lbl-1000:
        // 1 sources

        {
            try {
                in.close();
            }
            catch (Exception e) {
                Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("Close stream", (Throwable)e);
            }
        }
lbl59:
        // 3 sources

        return var9_13;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] getGifSize(File file) throws FileNotFoundException, IOException {
        int[] nArray;
        BufferedInputStream in = null;
        try {
            int[] dim;
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[10];
            int count = in.read(buf, 0, 10);
            if (count < 10) {
                throw new RuntimeException("File " + file + " is not a valid GIF file!");
            }
            if (buf[0] != 71 || buf[1] != 73 || buf[2] != 70) {
                throw new RuntimeException("File " + file + " is not a valid GIF file!");
            }
            int w1 = buf[6] & 0xFF | buf[6] & 0x80;
            int w2 = buf[7] & 0xFF | buf[7] & 0x80;
            int h1 = buf[8] & 0xFF | buf[8] & 0x80;
            int h2 = buf[9] & 0xFF | buf[9] & 0x80;
            int width = w1 + (w2 << 8);
            int height = h1 + (h2 << 8);
            nArray = dim = new int[]{width, height};
            Object var13_12 = null;
            if (in == null) return nArray;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("Close stream", (Throwable)e);
            }
            throw throwable;
        }
        try {
            in.close();
            return nArray;
        }
        catch (Exception e) {
            Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("Close stream", (Throwable)e);
        }
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    public static String getFileType(File file) throws FileNotFoundException, IOException {
        in = null;
        in = new BufferedInputStream(new FileInputStream(file));
        buf = new byte[3];
        count = in.read(buf, 0, 3);
        if (count >= 3) break block9;
        var4_4 = null;
        var9_5 = null;
        ** if (in == null) goto lbl-1000
lbl-1000:
        // 1 sources

        {
            try {
                in.close();
            }
            catch (Exception e) {
                Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("Close stream", (Throwable)e);
            }
        }
lbl-1000:
        // 3 sources

        {
            block9: {
                return var4_4;
            }
            if (buf[0] != 71 || buf[1] != 73 || buf[2] != 70) break block10;
            var5_15 = "gif";
        }
        var9_6 = null;
        if (in == null) ** GOTO lbl-1000
        try {
            in.close();
        }
        catch (Exception e) {
            Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("Close stream", (Throwable)e);
        }
lbl-1000:
        // 3 sources

        {
            block10: {
                return var5_15;
            }
            if (buf[0] != -1 || buf[1] != -40) break block11;
            var6_16 = "jpeg";
        }
        var9_7 = null;
        if (in == null) ** GOTO lbl-1000
        try {
            in.close();
        }
        catch (Exception e) {
            Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("Close stream", (Throwable)e);
        }
lbl-1000:
        // 3 sources

        {
            block11: {
                return var6_16;
            }
            var7_17 = null;
        }
        var9_8 = null;
        if (in == null) ** GOTO lbl51
        try {
            in.close();
        }
        catch (Exception e) {
            Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("Close stream", (Throwable)e);
        }
lbl51:
        // 3 sources

        return var7_17;
        catch (Throwable var8_18) {
            block12: {
                var9_9 = null;
                if (in == null) break block12;
                try {
                    in.close();
                }
                catch (Exception e) {
                    Hierarchy.getDefaultHierarchy().getLoggerFor("cocoon").debug("Close stream", (Throwable)e);
                }
            }
            throw var8_18;
        }
    }
}

